/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table;

import java.util.Map;
import org.apache.ignite.internal.schema.Column;
import org.apache.ignite.internal.schema.SchemaDescriptor;
import org.apache.ignite.internal.schema.SchemaRegistry;
import org.apache.ignite.internal.schema.marshaller.KvMarshaller;
import org.apache.ignite.internal.table.AbstractClientStreamerPartitionAwarenessProvider;
import org.apache.ignite.internal.type.NativeType;
import org.apache.ignite.internal.util.ColocationUtils;
import org.apache.ignite.internal.util.HashCalculator;
import org.apache.ignite.lang.MarshallerException;

class KeyValuePojoStreamerPartitionAwarenessProvider<K, V>
extends AbstractClientStreamerPartitionAwarenessProvider<Map.Entry<K, V>> {
    private final KvMarshaller<K, V> marsh;

    KeyValuePojoStreamerPartitionAwarenessProvider(SchemaRegistry schemaReg, int partitions, KvMarshaller<K, V> marsh) {
        super(schemaReg, partitions);
        assert (marsh != null);
        this.marsh = marsh;
    }

    @Override
    int colocationHash(SchemaDescriptor schema, Map.Entry<K, V> item) throws MarshallerException {
        HashCalculator hashCalc = new HashCalculator();
        for (Column c : schema.colocationColumns()) {
            Object val = this.marsh.value(item.getKey(), c.positionInRow());
            ColocationUtils.append((HashCalculator)hashCalc, (Object)val, (NativeType)c.type());
        }
        return hashCalc.hash();
    }
}

