/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rocksdb;

import java.nio.file.Paths;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.rocksdb.AbstractEventListener;
import org.rocksdb.CompactionJobInfo;
import org.rocksdb.FlushJobInfo;
import org.rocksdb.RocksDB;

public class LoggingRocksDbFlushListener
extends AbstractEventListener {
    private static final IgniteLogger LOG = Loggers.forClass(LoggingRocksDbFlushListener.class);
    private final String name;
    private final AtomicReference<AbstractEventListener.EnabledEventCallback> lastFlushEventType = new AtomicReference<AbstractEventListener.EnabledEventCallback>(AbstractEventListener.EnabledEventCallback.ON_FLUSH_COMPLETED);
    private final AtomicReference<AbstractEventListener.EnabledEventCallback> lastCompactionEventType = new AtomicReference<AbstractEventListener.EnabledEventCallback>(AbstractEventListener.EnabledEventCallback.ON_COMPACTION_COMPLETED);
    private volatile long lastFlushStartTimeNanos;
    private volatile long lastCompactionStartTimeNanos;

    public LoggingRocksDbFlushListener(String name) {
        super(new AbstractEventListener.EnabledEventCallback[]{AbstractEventListener.EnabledEventCallback.ON_FLUSH_BEGIN, AbstractEventListener.EnabledEventCallback.ON_FLUSH_COMPLETED, AbstractEventListener.EnabledEventCallback.ON_COMPACTION_BEGIN, AbstractEventListener.EnabledEventCallback.ON_COMPACTION_COMPLETED});
        this.name = name;
    }

    public void onFlushBegin(RocksDB db, FlushJobInfo flushJobInfo) {
        if (this.lastFlushEventType.compareAndSet(AbstractEventListener.EnabledEventCallback.ON_FLUSH_COMPLETED, AbstractEventListener.EnabledEventCallback.ON_FLUSH_BEGIN)) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Starting rocksdb flush process [name='{}', reason={}]", new Object[]{this.name, flushJobInfo.getFlushReason()});
                this.lastFlushStartTimeNanos = System.nanoTime();
            }
            this.onFlushBeginCallback(db, flushJobInfo);
        }
    }

    public void onFlushCompleted(RocksDB db, FlushJobInfo flushJobInfo) {
        if (this.lastFlushEventType.compareAndSet(AbstractEventListener.EnabledEventCallback.ON_FLUSH_BEGIN, AbstractEventListener.EnabledEventCallback.ON_FLUSH_COMPLETED)) {
            if (LOG.isInfoEnabled()) {
                long duration = System.nanoTime() - this.lastFlushStartTimeNanos;
                LOG.info("Finishing rocksdb flush process [name='{}', duration={}ms]", new Object[]{this.name, TimeUnit.NANOSECONDS.toMillis(duration)});
            }
            this.onFlushCompletedCallback(db, flushJobInfo);
        }
    }

    protected void onFlushBeginCallback(RocksDB db, FlushJobInfo flushJobInfo) {
    }

    protected void onFlushCompletedCallback(RocksDB db, FlushJobInfo flushJobInfo) {
    }

    public void onCompactionBegin(RocksDB db, CompactionJobInfo compactionJobInfo) {
        if (this.lastCompactionEventType.compareAndSet(AbstractEventListener.EnabledEventCallback.ON_COMPACTION_COMPLETED, AbstractEventListener.EnabledEventCallback.ON_COMPACTION_BEGIN) && LOG.isInfoEnabled()) {
            LOG.info("Starting rocksdb compaction process [name='{}', reason={}, input={}, output={}]", new Object[]{this.name, compactionJobInfo.compactionReason(), compactionJobInfo.inputFiles().stream().map(path -> Paths.get(path, new String[0]).getFileName()).collect(Collectors.toList()), compactionJobInfo.outputFiles().stream().map(path -> Paths.get(path, new String[0]).getFileName()).collect(Collectors.toList())});
            this.lastCompactionStartTimeNanos = System.nanoTime();
        }
    }

    public void onCompactionCompleted(RocksDB db, CompactionJobInfo compactionJobInfo) {
        if (this.lastCompactionEventType.compareAndSet(AbstractEventListener.EnabledEventCallback.ON_COMPACTION_BEGIN, AbstractEventListener.EnabledEventCallback.ON_COMPACTION_COMPLETED) && LOG.isInfoEnabled()) {
            long duration = System.nanoTime() - this.lastCompactionStartTimeNanos;
            LOG.info("Finishing rocksdb compaction process [name='{}', duration={}ms]", new Object[]{this.name, TimeUnit.NANOSECONDS.toMillis(duration)});
        }
    }
}

