/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.logger;

import java.io.PrintWriter;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite.internal.cli.logger.HttpLogging;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.lang.LoggerFactory;
import org.apache.ignite.rest.client.invoker.ApiClient;

public class CliLoggers {
    private static PrintWriter output;
    private static boolean isVerbose;
    private static boolean[] verbose;
    private static final Map<String, HttpLogging> httpLoggers;
    private static final LoggerFactory loggerFactory;

    public static IgniteLogger forClass(Class<?> cls) {
        return Loggers.forClass(cls, (LoggerFactory)loggerFactory);
    }

    public static void addApiClient(ApiClient client) {
        HttpLogging logger = httpLoggers.computeIfAbsent(client.getBasePath(), s -> new HttpLogging(client));
        if (isVerbose) {
            logger.startHttpLogging(output, verbose);
        }
    }

    public static void clearLoggers() {
        httpLoggers.clear();
    }

    public static void startOutputRedirect(PrintWriter out, boolean[] verbose) {
        output = out;
        isVerbose = true;
        CliLoggers.verbose = verbose;
        httpLoggers.values().forEach(logger -> logger.startHttpLogging(out, verbose));
    }

    public static void stopOutputRedirect() {
        output = null;
        isVerbose = false;
        verbose = new boolean[0];
        httpLoggers.values().forEach(HttpLogging::stopHttpLogging);
    }

    public static boolean isVerbose() {
        return isVerbose;
    }

    static {
        httpLoggers = new ConcurrentHashMap<String, HttpLogging>();
        loggerFactory = name -> new CliLogger(System.getLogger(name));
    }

    private static class CliLogger
    implements System.Logger {
        private final System.Logger delegate;

        private CliLogger(System.Logger delegate) {
            this.delegate = delegate;
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public boolean isLoggable(System.Logger.Level level) {
            return this.delegate.isLoggable(level) || isVerbose;
        }

        @Override
        public void log(System.Logger.Level level, ResourceBundle bundle, String msg, Throwable thrown) {
            if (isVerbose) {
                output.println(msg);
                output.println(thrown.getMessage());
            }
            this.delegate.log(level, bundle, msg, thrown);
        }

        @Override
        public void log(System.Logger.Level level, ResourceBundle bundle, String format, Object ... params) {
            if (isVerbose) {
                output.println(format);
            }
            this.delegate.log(level, bundle, format, params);
        }
    }
}

