/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.core.rest;

import java.util.Objects;
import org.apache.ignite.internal.cli.core.rest.ApiClientSettingsBuilder;

public class ApiClientSettings {
    private final String basePath;
    private final String keyStorePath;
    private final String keyStorePassword;
    private final String trustStorePath;
    private final String trustStorePassword;
    private final String ciphers;
    private final String basicAuthenticationUsername;
    private final String basicAuthenticationPassword;

    ApiClientSettings(String basePath, String keyStorePath, String keyStorePassword, String trustStorePath, String trustStorePassword, String ciphers, String basicAuthenticationUsername, String basicAuthenticationPassword) {
        this.basePath = basePath;
        this.keyStorePath = keyStorePath;
        this.keyStorePassword = keyStorePassword;
        this.trustStorePath = trustStorePath;
        this.trustStorePassword = trustStorePassword;
        this.ciphers = ciphers;
        this.basicAuthenticationUsername = basicAuthenticationUsername;
        this.basicAuthenticationPassword = basicAuthenticationPassword;
    }

    public static ApiClientSettingsBuilder builder() {
        return new ApiClientSettingsBuilder();
    }

    public String basePath() {
        return this.basePath;
    }

    public String keyStorePath() {
        return this.keyStorePath;
    }

    public String keyStorePassword() {
        return this.keyStorePassword;
    }

    public String trustStorePath() {
        return this.trustStorePath;
    }

    public String trustStorePassword() {
        return this.trustStorePassword;
    }

    public String ciphers() {
        return this.ciphers;
    }

    public String basicAuthenticationUsername() {
        return this.basicAuthenticationUsername;
    }

    public String basicAuthenticationPassword() {
        return this.basicAuthenticationPassword;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiClientSettings that = (ApiClientSettings)o;
        return Objects.equals(this.basePath, that.basePath) && Objects.equals(this.keyStorePath, that.keyStorePath) && Objects.equals(this.keyStorePassword, that.keyStorePassword) && Objects.equals(this.trustStorePath, that.trustStorePath) && Objects.equals(this.trustStorePassword, that.trustStorePassword) && Objects.equals(this.ciphers, that.ciphers) && Objects.equals(this.basicAuthenticationUsername, that.basicAuthenticationUsername) && Objects.equals(this.basicAuthenticationPassword, that.basicAuthenticationPassword);
    }

    public int hashCode() {
        return Objects.hash(this.basePath, this.keyStorePath, this.keyStorePassword, this.trustStorePath, this.trustStorePassword, this.ciphers, this.basicAuthenticationUsername, this.basicAuthenticationPassword);
    }
}

