/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.call.cluster.status;

import jakarta.inject.Singleton;
import java.util.List;
import org.apache.ignite.internal.cli.call.cluster.status.ClusterStatus;
import org.apache.ignite.internal.cli.call.cluster.topology.PhysicalTopologyCall;
import org.apache.ignite.internal.cli.core.call.Call;
import org.apache.ignite.internal.cli.core.call.CallOutput;
import org.apache.ignite.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite.internal.cli.core.call.UrlCallInput;
import org.apache.ignite.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite.rest.client.api.ClusterManagementApi;
import org.apache.ignite.rest.client.invoker.ApiException;
import org.apache.ignite.rest.client.model.ClusterNode;
import org.apache.ignite.rest.client.model.ClusterState;

@Singleton
public class ClusterStatusCall
implements Call<UrlCallInput, ClusterStatus> {
    private final PhysicalTopologyCall physicalTopologyCall;
    private final ApiClientFactory clientFactory;

    public ClusterStatusCall(PhysicalTopologyCall physicalTopologyCall, ApiClientFactory clientFactory) {
        this.physicalTopologyCall = physicalTopologyCall;
        this.clientFactory = clientFactory;
    }

    @Override
    public CallOutput<ClusterStatus> execute(UrlCallInput input) {
        ClusterStatus.ClusterStatusBuilder clusterStatusBuilder = ClusterStatus.builder();
        String clusterUrl = input.getUrl();
        try {
            ClusterState clusterState = this.fetchClusterState(clusterUrl);
            clusterStatusBuilder.nodeCount(this.fetchNumberOfAllNodes(input)).initialized(true).name(clusterState.getClusterTag().getClusterName()).metadataStorageNodes(clusterState.getMsNodes()).cmgNodes(clusterState.getCmgNodes());
        }
        catch (ApiException e) {
            if (e.getCode() == 409) {
                clusterStatusBuilder.initialized(false).nodeCount(this.fetchNumberOfAllNodes(input));
            }
            return DefaultCallOutput.failure(new IgniteCliApiException(e, clusterUrl));
        }
        catch (IllegalArgumentException e) {
            return DefaultCallOutput.failure(new IgniteCliApiException(e, clusterUrl));
        }
        return DefaultCallOutput.success(clusterStatusBuilder.build());
    }

    private int fetchNumberOfAllNodes(UrlCallInput input) {
        List<ClusterNode> body = this.physicalTopologyCall.execute(input).body();
        if (body == null) {
            return -1;
        }
        return body.size();
    }

    private ClusterState fetchClusterState(String url) throws ApiException {
        return new ClusterManagementApi(this.clientFactory.getClient(url)).clusterState();
    }
}

