/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.ast;

import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.SegmentedSequence;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class BlockContent {
    private final ArrayList<BasedSequence> lines = new ArrayList();
    private final ArrayList<Integer> lineIndents = new ArrayList();

    @NotNull
    public BasedSequence getLine(int line) {
        return this.lines.get(line);
    }

    @NotNull
    public BasedSequence getSpanningChars() {
        return this.lines.size() > 0 ? this.lines.get(0).baseSubSequence(this.lines.get(0).getStartOffset(), this.lines.get(this.lines.size() - 1).getEndOffset()) : BasedSequence.NULL;
    }

    @NotNull
    public List<BasedSequence> getLines() {
        return this.lines;
    }

    @NotNull
    public List<Integer> getLineIndents() {
        return this.lineIndents;
    }

    public int getLineCount() {
        return this.lines.size();
    }

    public BlockContent() {
    }

    public BlockContent(@NotNull BlockContent other, int startLine, int lineIndent) {
        assert (other.lines.size() == other.lineIndents.size()) : "lines and eols should be of the same size";
        if (other.lines.size() > 0 && startLine < lineIndent) {
            this.lines.addAll(other.lines.subList(startLine, lineIndent));
            this.lineIndents.addAll(other.lineIndents.subList(startLine, lineIndent));
        }
    }

    public int getStartOffset() {
        return this.lines.size() > 0 ? this.lines.get(0).getStartOffset() : -1;
    }

    public int getEndOffset() {
        return this.lines.size() > 0 ? this.lines.get(this.lines.size() - 1).getEndOffset() : -1;
    }

    public int getLineIndent() {
        return this.lines.size() > 0 ? this.lineIndents.get(0) : 0;
    }

    public int getSourceLength() {
        return this.lines.size() > 0 ? this.lines.get(this.lines.size() - 1).getEndOffset() - this.lines.get(0).getStartOffset() : -1;
    }

    public void add(@NotNull BasedSequence lineWithEOL, int lineIndent) {
        this.lines.add(lineWithEOL);
        this.lineIndents.add(lineIndent);
    }

    public void addAll(@NotNull List<BasedSequence> lines, List<Integer> lineIndents) {
        assert (lines.size() == lineIndents.size()) : "lines and lineIndents should be of the same size";
        this.lines.addAll(lines);
        this.lineIndents.addAll(lineIndents);
    }

    public boolean hasSingleLine() {
        return this.lines.size() == 1;
    }

    @NotNull
    public BasedSequence getContents() {
        if (this.lines.size() == 0) {
            return BasedSequence.NULL;
        }
        return this.getContents(0, this.lines.size());
    }

    @NotNull
    public BlockContent subContents(int startLine, int endLine) {
        return new BlockContent(this, startLine, endLine);
    }

    @NotNull
    public BasedSequence getContents(int startLine, int endLine) {
        if (this.lines.size() == 0) {
            return BasedSequence.NULL;
        }
        if (startLine < 0) {
            throw new IndexOutOfBoundsException("startLine must be at least 0");
        }
        if (endLine < 0) {
            throw new IndexOutOfBoundsException("endLine must be at least 0");
        }
        if (endLine < startLine) {
            throw new IndexOutOfBoundsException("endLine must not be less than startLine");
        }
        if (endLine > this.lines.size()) {
            throw new IndexOutOfBoundsException("endLine must not be greater than line cardinality");
        }
        return SegmentedSequence.create((BasedSequence)this.lines.get(0), this.lines.subList(startLine, endLine));
    }

    @NotNull
    public String getString() {
        if (this.lines.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (BasedSequence line : this.lines) {
            sb.append((CharSequence)line.trimEOL());
            sb.append('\n');
        }
        return sb.toString();
    }
}

