/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util.format.postgresql;

import com.google.common.collect.ImmutableList;
import java.text.ParseException;
import java.text.ParsePosition;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.IsoFields;
import java.time.temporal.JulianFields;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.calcite.util.format.postgresql.ChronoUnitEnum;
import org.apache.calcite.util.format.postgresql.DateCalendarEnum;
import org.apache.calcite.util.format.postgresql.format.compiled.CompiledItem;
import org.apache.calcite.util.format.postgresql.format.compiled.CompiledPattern;
import org.apache.calcite.util.format.postgresql.format.compiled.LiteralCompiledItem;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CompiledDateTimeFormat {
    private final ImmutableList<CompiledItem> compiledItems;

    public CompiledDateTimeFormat(ImmutableList<CompiledItem> compiledItems) {
        this.compiledItems = compiledItems;
    }

    public ZonedDateTime parseDateTime(String input, ZoneId zoneId, Locale locale) throws ParseException {
        ParsePosition parsePosition = new ParsePosition(0);
        HashMap<ChronoUnitEnum, Integer> dateTimeParts = new HashMap<ChronoUnitEnum, Integer>();
        for (int i = 0; i < this.compiledItems.size(); ++i) {
            CompiledItem currentFormatItem = (CompiledItem)this.compiledItems.get(i);
            boolean nextItemNumeric = this.isItemNumeric(i + 1);
            if (currentFormatItem instanceof LiteralCompiledItem) {
                LiteralCompiledItem literal = (LiteralCompiledItem)currentFormatItem;
                parsePosition.setIndex(parsePosition.getIndex() + literal.getFormatPatternLength());
                continue;
            }
            if (!(currentFormatItem instanceof CompiledPattern)) continue;
            CompiledPattern pattern = (CompiledPattern)currentFormatItem;
            dateTimeParts.put(pattern.getChronoUnit(), pattern.parseValue(parsePosition, input, nextItemNumeric, locale));
        }
        return CompiledDateTimeFormat.constructDateTimeFromParts(dateTimeParts, zoneId);
    }

    private boolean isItemNumeric(int index) {
        if (index < this.compiledItems.size() && this.compiledItems.get(index) instanceof CompiledPattern) {
            return ((CompiledPattern)this.compiledItems.get(index)).isNumeric();
        }
        return false;
    }

    public String formatDateTime(ZonedDateTime dateTime, Locale locale) {
        StringBuilder outputBuilder = new StringBuilder();
        for (CompiledItem compiledItem : this.compiledItems) {
            outputBuilder.append(compiledItem.convertToString(dateTime, locale));
        }
        return outputBuilder.toString();
    }

    private static ZonedDateTime constructDateTimeFromParts(Map<ChronoUnitEnum, Integer> dateParts, ZoneId zoneId) {
        LocalDateTime constructedDateTime = LocalDateTime.now(zoneId).truncatedTo(ChronoUnit.DAYS);
        DateCalendarEnum calendar = DateCalendarEnum.NONE;
        boolean containsCentury = false;
        for (ChronoUnitEnum unit : dateParts.keySet()) {
            if (unit.getCalendars().size() == 1) {
                DateCalendarEnum unitCalendar = unit.getCalendars().iterator().next();
                if (unitCalendar == DateCalendarEnum.NONE) continue;
                calendar = unitCalendar;
                break;
            }
            if (unit != ChronoUnitEnum.CENTURIES) continue;
            containsCentury = true;
        }
        if (calendar == DateCalendarEnum.NONE && containsCentury) {
            calendar = DateCalendarEnum.GREGORIAN;
        }
        switch (calendar) {
            case NONE: {
                constructedDateTime = constructedDateTime.withYear(1).withMonth(1).withDayOfMonth(1);
                break;
            }
            case GREGORIAN: {
                constructedDateTime = CompiledDateTimeFormat.updateWithGregorianFields(constructedDateTime, dateParts);
                break;
            }
            case ISO_8601: {
                constructedDateTime = CompiledDateTimeFormat.updateWithIso8601Fields(constructedDateTime, dateParts);
                break;
            }
            case JULIAN: {
                Integer julianDays = dateParts.get((Object)ChronoUnitEnum.DAYS_JULIAN);
                if (julianDays == null) break;
                constructedDateTime = constructedDateTime.with(JulianFields.JULIAN_DAY, julianDays.intValue());
            }
        }
        constructedDateTime = CompiledDateTimeFormat.updateWithTimeFields(constructedDateTime, dateParts);
        if (dateParts.containsKey((Object)ChronoUnitEnum.TIMEZONE_HOURS) || dateParts.containsKey((Object)ChronoUnitEnum.TIMEZONE_MINUTES)) {
            int hours = dateParts.getOrDefault((Object)ChronoUnitEnum.TIMEZONE_HOURS, 0);
            int minutes = dateParts.getOrDefault((Object)ChronoUnitEnum.TIMEZONE_MINUTES, 0);
            return ZonedDateTime.of(constructedDateTime, ZoneOffset.ofHoursMinutes(hours, minutes)).withZoneSameInstant(zoneId);
        }
        return ZonedDateTime.of(constructedDateTime, zoneId);
    }

    private static LocalDateTime updateWithGregorianFields(LocalDateTime dateTime, Map<ChronoUnitEnum, Integer> dateParts) {
        LocalDateTime updatedDateTime = dateTime.withYear(CompiledDateTimeFormat.getGregorianYear(dateParts)).withDayOfYear(1);
        if (dateParts.containsKey((Object)ChronoUnitEnum.MONTHS_IN_YEAR)) {
            updatedDateTime = updatedDateTime.withMonth(dateParts.get((Object)ChronoUnitEnum.MONTHS_IN_YEAR));
        }
        if (dateParts.containsKey((Object)ChronoUnitEnum.DAYS_IN_MONTH)) {
            updatedDateTime = updatedDateTime.withDayOfMonth(dateParts.get((Object)ChronoUnitEnum.DAYS_IN_MONTH));
        }
        if (dateParts.containsKey((Object)ChronoUnitEnum.WEEKS_IN_MONTH)) {
            updatedDateTime = updatedDateTime.withDayOfMonth(dateParts.get((Object)ChronoUnitEnum.WEEKS_IN_MONTH) * 7 - 6);
        }
        if (dateParts.containsKey((Object)ChronoUnitEnum.WEEKS_IN_YEAR)) {
            updatedDateTime = updatedDateTime.withDayOfYear(dateParts.get((Object)ChronoUnitEnum.WEEKS_IN_YEAR) * 7 - 6);
        }
        if (dateParts.containsKey((Object)ChronoUnitEnum.DAYS_IN_YEAR)) {
            updatedDateTime = updatedDateTime.withDayOfYear(dateParts.get((Object)ChronoUnitEnum.DAYS_IN_YEAR));
        }
        return updatedDateTime;
    }

    private static int getGregorianYear(Map<ChronoUnitEnum, Integer> dateParts) {
        int year = CompiledDateTimeFormat.getYear(dateParts.get((Object)ChronoUnitEnum.ERAS), dateParts.get((Object)ChronoUnitEnum.YEARS), dateParts.get((Object)ChronoUnitEnum.CENTURIES), dateParts.get((Object)ChronoUnitEnum.YEARS_IN_MILLENIA), dateParts.get((Object)ChronoUnitEnum.YEARS_IN_CENTURY));
        return year == 0 ? 1 : year;
    }

    private static LocalDateTime updateWithIso8601Fields(LocalDateTime dateTime, Map<ChronoUnitEnum, Integer> dateParts) {
        int year = CompiledDateTimeFormat.getIso8601Year(dateParts);
        if (!dateParts.containsKey((Object)ChronoUnitEnum.WEEKS_IN_YEAR_ISO_8601) && !dateParts.containsKey((Object)ChronoUnitEnum.DAYS_IN_YEAR_ISO_8601)) {
            return dateTime.withYear(year).withDayOfYear(1);
        }
        LocalDateTime updatedDateTime = dateTime.with(ChronoField.DAY_OF_WEEK, 1L).with(IsoFields.WEEK_BASED_YEAR, year).with(IsoFields.WEEK_OF_WEEK_BASED_YEAR, 1L);
        if (dateParts.containsKey((Object)ChronoUnitEnum.WEEKS_IN_YEAR_ISO_8601)) {
            updatedDateTime = updatedDateTime.with(IsoFields.WEEK_OF_WEEK_BASED_YEAR, dateParts.get((Object)ChronoUnitEnum.WEEKS_IN_YEAR_ISO_8601).intValue());
            if (dateParts.containsKey((Object)ChronoUnitEnum.DAYS_IN_WEEK)) {
                updatedDateTime = updatedDateTime.with(ChronoField.DAY_OF_WEEK, dateParts.get((Object)ChronoUnitEnum.DAYS_IN_WEEK).intValue());
            }
        } else if (dateParts.containsKey((Object)ChronoUnitEnum.DAYS_IN_YEAR_ISO_8601)) {
            updatedDateTime = updatedDateTime.plusDays(dateParts.get((Object)ChronoUnitEnum.DAYS_IN_YEAR_ISO_8601) - 1);
        }
        return updatedDateTime;
    }

    private static int getIso8601Year(Map<ChronoUnitEnum, Integer> dateParts) {
        int year = CompiledDateTimeFormat.getYear(dateParts.get((Object)ChronoUnitEnum.ERAS), dateParts.get((Object)ChronoUnitEnum.YEARS_ISO_8601), dateParts.get((Object)ChronoUnitEnum.CENTURIES), dateParts.get((Object)ChronoUnitEnum.YEARS_IN_MILLENIA_ISO_8601), dateParts.get((Object)ChronoUnitEnum.YEARS_IN_CENTURY_ISO_8601));
        return year == 0 ? 1 : year;
    }

    private static int getYear(@Nullable Integer era, @Nullable Integer years, @Nullable Integer centuries, @Nullable Integer yearsInMillenia, @Nullable Integer yearsInCentury) {
        int yearSign = 1;
        if (era != null && era == 0) {
            yearSign = -1;
        }
        if (yearsInMillenia != null) {
            int year = yearsInMillenia;
            year = year < 520 ? (year += 2000) : (year += 1000);
            return yearSign * year;
        }
        if (centuries != null) {
            int year = 100 * (centuries - 1);
            year = yearsInCentury != null ? (year += yearsInCentury.intValue()) : ++year;
            return yearSign * year;
        }
        if (years != null) {
            return yearSign * years;
        }
        if (yearsInCentury != null) {
            int year = yearsInCentury;
            if (year < 70) {
                year += 2000;
            } else if (year < 100) {
                year += 1900;
            }
            return yearSign * year;
        }
        return yearSign;
    }

    private static LocalDateTime updateWithTimeFields(LocalDateTime dateTime, Map<ChronoUnitEnum, Integer> dateParts) {
        LocalDateTime updatedDateTime = dateTime;
        if (dateParts.containsKey((Object)ChronoUnitEnum.HOURS_IN_DAY)) {
            updatedDateTime = updatedDateTime.withHour(dateParts.get((Object)ChronoUnitEnum.HOURS_IN_DAY));
        }
        if (dateParts.containsKey((Object)ChronoUnitEnum.HALF_DAYS) && dateParts.containsKey((Object)ChronoUnitEnum.HOURS_IN_HALF_DAY)) {
            updatedDateTime = updatedDateTime.withHour(dateParts.get((Object)ChronoUnitEnum.HALF_DAYS) * 12 + dateParts.get((Object)ChronoUnitEnum.HOURS_IN_HALF_DAY));
        } else if (dateParts.containsKey((Object)ChronoUnitEnum.HOURS_IN_HALF_DAY)) {
            updatedDateTime = updatedDateTime.withHour(dateParts.get((Object)ChronoUnitEnum.HOURS_IN_HALF_DAY));
        }
        if (dateParts.containsKey((Object)ChronoUnitEnum.MINUTES_IN_HOUR)) {
            updatedDateTime = updatedDateTime.withMinute(dateParts.get((Object)ChronoUnitEnum.MINUTES_IN_HOUR));
        }
        if (dateParts.containsKey((Object)ChronoUnitEnum.SECONDS_IN_DAY)) {
            updatedDateTime = updatedDateTime.with(ChronoField.SECOND_OF_DAY, dateParts.get((Object)ChronoUnitEnum.SECONDS_IN_DAY).intValue());
        }
        if (dateParts.containsKey((Object)ChronoUnitEnum.SECONDS_IN_MINUTE)) {
            updatedDateTime = updatedDateTime.withSecond(dateParts.get((Object)ChronoUnitEnum.SECONDS_IN_MINUTE));
        }
        if (dateParts.containsKey((Object)ChronoUnitEnum.MILLIS)) {
            updatedDateTime = updatedDateTime.with(ChronoField.MILLI_OF_SECOND, dateParts.get((Object)ChronoUnitEnum.MILLIS).intValue());
        }
        if (dateParts.containsKey((Object)ChronoUnitEnum.MICROS)) {
            updatedDateTime = updatedDateTime.with(ChronoField.MICRO_OF_SECOND, dateParts.get((Object)ChronoUnitEnum.MICROS).intValue());
        }
        if (dateParts.containsKey((Object)ChronoUnitEnum.TENTHS_OF_SECOND)) {
            updatedDateTime = updatedDateTime.with(ChronoField.MILLI_OF_SECOND, 100L * (long)dateParts.get((Object)ChronoUnitEnum.TENTHS_OF_SECOND).intValue());
        }
        if (dateParts.containsKey((Object)ChronoUnitEnum.HUNDREDTHS_OF_SECOND)) {
            updatedDateTime = updatedDateTime.with(ChronoField.MILLI_OF_SECOND, 10L * (long)dateParts.get((Object)ChronoUnitEnum.HUNDREDTHS_OF_SECOND).intValue());
        }
        if (dateParts.containsKey((Object)ChronoUnitEnum.THOUSANDTHS_OF_SECOND)) {
            updatedDateTime = updatedDateTime.with(ChronoField.MILLI_OF_SECOND, dateParts.get((Object)ChronoUnitEnum.THOUSANDTHS_OF_SECOND).intValue());
        }
        if (dateParts.containsKey((Object)ChronoUnitEnum.TENTHS_OF_MS)) {
            updatedDateTime = updatedDateTime.with(ChronoField.MICRO_OF_SECOND, 100L * (long)dateParts.get((Object)ChronoUnitEnum.TENTHS_OF_MS).intValue());
        }
        if (dateParts.containsKey((Object)ChronoUnitEnum.HUNDREDTHS_OF_MS)) {
            updatedDateTime = updatedDateTime.with(ChronoField.MICRO_OF_SECOND, 10L * (long)dateParts.get((Object)ChronoUnitEnum.HUNDREDTHS_OF_MS).intValue());
        }
        if (dateParts.containsKey((Object)ChronoUnitEnum.THOUSANDTHS_OF_MS)) {
            updatedDateTime = updatedDateTime.with(ChronoField.MICRO_OF_SECOND, dateParts.get((Object)ChronoUnitEnum.THOUSANDTHS_OF_MS).intValue());
        }
        return updatedDateTime;
    }
}

