/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlTypeNameSpec;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.Pair;

public class SqlRowTypeNameSpec
extends SqlTypeNameSpec {
    private final List<SqlIdentifier> fieldNames;
    private final List<SqlDataTypeSpec> fieldTypes;

    public SqlRowTypeNameSpec(SqlParserPos pos, List<SqlIdentifier> fieldNames, List<SqlDataTypeSpec> fieldTypes) {
        super(new SqlIdentifier(SqlTypeName.ROW.getName(), pos), pos);
        this.fieldNames = Objects.requireNonNull(fieldNames, "fieldNames");
        this.fieldTypes = Objects.requireNonNull(fieldTypes, "fieldTypes");
        assert (!fieldNames.isEmpty());
    }

    public List<SqlIdentifier> getFieldNames() {
        return this.fieldNames;
    }

    public List<SqlDataTypeSpec> getFieldTypes() {
        return this.fieldTypes;
    }

    public int getArity() {
        return this.fieldNames.size();
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.print(this.getTypeName().getSimple());
        SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.FUN_CALL, "(", ")");
        for (Pair<SqlIdentifier, SqlDataTypeSpec> p : Pair.zip(this.fieldNames, this.fieldTypes)) {
            writer.sep(",", false);
            ((SqlIdentifier)p.left).unparse(writer, 0, 0);
            ((SqlDataTypeSpec)p.right).unparse(writer, leftPrec, rightPrec);
            Boolean isNullable = ((SqlDataTypeSpec)p.right).getNullable();
            if (isNullable == null || !isNullable.booleanValue()) continue;
            writer.print("NULL");
        }
        writer.endList(frame);
    }

    @Override
    public boolean equalsDeep(SqlTypeNameSpec node, Litmus litmus) {
        if (!(node instanceof SqlRowTypeNameSpec)) {
            return litmus.fail("{} != {}", this, node);
        }
        SqlRowTypeNameSpec that = (SqlRowTypeNameSpec)node;
        if (!SqlNode.equalDeep(this.fieldNames, that.fieldNames, litmus.withMessageArgs("{} != {}", this, node))) {
            return litmus.fail("{} != {}", this, node);
        }
        if (!SqlNode.equalDeep(this.fieldTypes, that.fieldTypes, litmus.withMessageArgs("{} != {}", this, node))) {
            return litmus.fail("{} != {}", this, node);
        }
        return litmus.succeed();
    }

    @Override
    public RelDataType deriveType(SqlValidator sqlValidator) {
        RelDataTypeFactory typeFactory = sqlValidator.getTypeFactory();
        return typeFactory.createStructType(this.fieldTypes.stream().map(dt -> dt.deriveType(sqlValidator)).collect(Collectors.toList()), this.fieldNames.stream().map(SqlIdentifier::toString).collect(Collectors.toList()));
    }
}

