/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlPrefixOperator;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.Symbolizable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.util.SqlBasicVisitor;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.util.ImmutableNullableList;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SqlMatchRecognize
extends SqlCall {
    public static final int OPERAND_TABLE_REF = 0;
    public static final int OPERAND_PATTERN = 1;
    public static final int OPERAND_STRICT_START = 2;
    public static final int OPERAND_STRICT_END = 3;
    public static final int OPERAND_PATTERN_DEFINES = 4;
    public static final int OPERAND_MEASURES = 5;
    public static final int OPERAND_AFTER = 6;
    public static final int OPERAND_SUBSET = 7;
    public static final int OPERAND_ROWS_PER_MATCH = 8;
    public static final int OPERAND_PARTITION_BY = 9;
    public static final int OPERAND_ORDER_BY = 10;
    public static final int OPERAND_INTERVAL = 11;
    public static final SqlPrefixOperator SKIP_TO_FIRST = new SqlPrefixOperator("SKIP TO FIRST", SqlKind.SKIP_TO_FIRST, 20, null, null, null);
    public static final SqlPrefixOperator SKIP_TO_LAST = new SqlPrefixOperator("SKIP TO LAST", SqlKind.SKIP_TO_LAST, 20, null, null, null);
    private SqlNode tableRef;
    private SqlNode pattern;
    private SqlLiteral strictStart;
    private SqlLiteral strictEnd;
    private SqlNodeList patternDefList;
    private SqlNodeList measureList;
    private @Nullable SqlNode after;
    private SqlNodeList subsetList;
    private @Nullable SqlLiteral rowsPerMatch;
    private SqlNodeList partitionList;
    private SqlNodeList orderList;
    private @Nullable SqlLiteral interval;

    public SqlMatchRecognize(SqlParserPos pos, SqlNode tableRef, SqlNode pattern, SqlLiteral strictStart, SqlLiteral strictEnd, SqlNodeList patternDefList, SqlNodeList measureList, @Nullable SqlNode after, SqlNodeList subsetList, @Nullable SqlLiteral rowsPerMatch, SqlNodeList partitionList, SqlNodeList orderList, @Nullable SqlLiteral interval) {
        super(pos);
        this.tableRef = Objects.requireNonNull(tableRef, "tableRef");
        this.pattern = Objects.requireNonNull(pattern, "pattern");
        this.strictStart = strictStart;
        this.strictEnd = strictEnd;
        this.patternDefList = Objects.requireNonNull(patternDefList, "patternDefList");
        Preconditions.checkArgument((!patternDefList.isEmpty() ? 1 : 0) != 0);
        this.measureList = Objects.requireNonNull(measureList, "measureList");
        this.after = after;
        this.subsetList = subsetList;
        Preconditions.checkArgument((rowsPerMatch == null || rowsPerMatch.value instanceof RowsPerMatchOption ? 1 : 0) != 0);
        this.rowsPerMatch = rowsPerMatch;
        this.partitionList = Objects.requireNonNull(partitionList, "partitionList");
        this.orderList = Objects.requireNonNull(orderList, "orderList");
        this.interval = interval;
    }

    @Override
    public SqlOperator getOperator() {
        return SqlMatchRecognizeOperator.INSTANCE;
    }

    @Override
    public SqlKind getKind() {
        return SqlKind.MATCH_RECOGNIZE;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.tableRef, this.pattern, this.strictStart, this.strictEnd, this.patternDefList, this.measureList, this.after, this.subsetList, new SqlNode[]{this.rowsPerMatch, this.partitionList, this.orderList, this.interval});
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        this.getOperator().unparse(writer, this, 0, 0);
    }

    @Override
    public void validate(SqlValidator validator, SqlValidatorScope scope) {
        validator.validateMatchRecognize(this);
    }

    @Override
    public void setOperand(int i, @Nullable SqlNode operand) {
        switch (i) {
            case 0: {
                this.tableRef = Objects.requireNonNull(operand, "operand");
                break;
            }
            case 1: {
                this.pattern = operand;
                break;
            }
            case 2: {
                this.strictStart = (SqlLiteral)operand;
                break;
            }
            case 3: {
                this.strictEnd = (SqlLiteral)operand;
                break;
            }
            case 4: {
                this.patternDefList = Objects.requireNonNull((SqlNodeList)operand);
                Preconditions.checkArgument((!this.patternDefList.isEmpty() ? 1 : 0) != 0);
                break;
            }
            case 5: {
                this.measureList = Objects.requireNonNull((SqlNodeList)operand);
                break;
            }
            case 6: {
                this.after = operand;
                break;
            }
            case 7: {
                this.subsetList = (SqlNodeList)operand;
                break;
            }
            case 8: {
                this.rowsPerMatch = (SqlLiteral)operand;
                Preconditions.checkArgument((this.rowsPerMatch == null || this.rowsPerMatch.value instanceof RowsPerMatchOption ? 1 : 0) != 0);
                break;
            }
            case 9: {
                this.partitionList = (SqlNodeList)operand;
                break;
            }
            case 10: {
                this.orderList = (SqlNodeList)operand;
                break;
            }
            case 11: {
                this.interval = (SqlLiteral)operand;
                break;
            }
            default: {
                throw new AssertionError(i);
            }
        }
    }

    public SqlNode getTableRef() {
        return this.tableRef;
    }

    public SqlNode getPattern() {
        return this.pattern;
    }

    public SqlLiteral getStrictStart() {
        return this.strictStart;
    }

    public SqlLiteral getStrictEnd() {
        return this.strictEnd;
    }

    public SqlNodeList getPatternDefList() {
        return this.patternDefList;
    }

    public SqlNodeList getMeasureList() {
        return this.measureList;
    }

    public @Nullable SqlNode getAfter() {
        return this.after;
    }

    public SqlNodeList getSubsetList() {
        return this.subsetList;
    }

    public @Nullable SqlLiteral getRowsPerMatch() {
        return this.rowsPerMatch;
    }

    public SqlNodeList getPartitionList() {
        return this.partitionList;
    }

    public SqlNodeList getOrderList() {
        return this.orderList;
    }

    public @Nullable SqlLiteral getInterval() {
        return this.interval;
    }

    public static class SqlMatchRecognizeOperator
    extends SqlOperator {
        public static final SqlMatchRecognizeOperator INSTANCE = new SqlMatchRecognizeOperator();

        private SqlMatchRecognizeOperator() {
            super("MATCH_RECOGNIZE", SqlKind.MATCH_RECOGNIZE, 2, true, null, null, null);
        }

        @Override
        public SqlSyntax getSyntax() {
            return SqlSyntax.SPECIAL;
        }

        @Override
        public SqlCall createCall(@Nullable SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            assert (functionQualifier == null);
            assert (operands.length == 12);
            return new SqlMatchRecognize(pos, operands[0], operands[1], (SqlLiteral)operands[2], (SqlLiteral)operands[3], (SqlNodeList)operands[4], (SqlNodeList)operands[5], operands[6], (SqlNodeList)operands[7], (SqlLiteral)operands[8], (SqlNodeList)operands[9], (SqlNodeList)operands[10], (SqlLiteral)operands[11]);
        }

        @Override
        public <R> void acceptCall(SqlVisitor<R> visitor, SqlCall call, boolean onlyExpressions, SqlBasicVisitor.ArgHandler<R> argHandler) {
            if (onlyExpressions) {
                List<SqlNode> operands = call.getOperandList();
                for (int i = 0; i < operands.size(); ++i) {
                    SqlNode operand = operands.get(i);
                    if (operand == null) continue;
                    argHandler.visitChild(visitor, call, i, operand);
                }
            } else {
                super.acceptCall(visitor, call, onlyExpressions, argHandler);
            }
        }

        @Override
        public void validateCall(SqlCall call, SqlValidator validator, SqlValidatorScope scope, SqlValidatorScope operandScope) {
            validator.validateMatchRecognize(call);
        }

        @Override
        public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
            SqlNode after;
            SqlLiteral rowsPerMatch;
            SqlMatchRecognize pattern = (SqlMatchRecognize)call;
            pattern.tableRef.unparse(writer, 0, 0);
            SqlWriter.Frame mrFrame = writer.startFunCall("MATCH_RECOGNIZE");
            if (!pattern.partitionList.isEmpty()) {
                writer.newlineAndIndent();
                writer.sep("PARTITION BY");
                SqlWriter.Frame partitionFrame = writer.startList("", "");
                pattern.partitionList.unparse(writer, 0, 0);
                writer.endList(partitionFrame);
            }
            if (!pattern.orderList.isEmpty()) {
                writer.newlineAndIndent();
                writer.sep("ORDER BY");
                writer.list(SqlWriter.FrameTypeEnum.ORDER_BY_LIST, SqlWriter.COMMA, pattern.orderList);
            }
            if (!pattern.measureList.isEmpty()) {
                writer.newlineAndIndent();
                writer.sep("MEASURES");
                SqlWriter.Frame measureFrame = writer.startList("", "");
                pattern.measureList.unparse(writer, 0, 0);
                writer.endList(measureFrame);
            }
            if ((rowsPerMatch = pattern.rowsPerMatch) != null) {
                writer.newlineAndIndent();
                rowsPerMatch.unparse(writer, 0, 0);
            }
            if ((after = pattern.after) != null) {
                writer.newlineAndIndent();
                writer.sep("AFTER MATCH");
                after.unparse(writer, 0, 0);
            }
            writer.newlineAndIndent();
            writer.sep("PATTERN");
            SqlWriter.Frame patternFrame = writer.startList("(", ")");
            if (pattern.strictStart.booleanValue()) {
                writer.sep("^");
            }
            pattern.pattern.unparse(writer, 0, 0);
            if (pattern.strictEnd.booleanValue()) {
                writer.sep("$");
            }
            writer.endList(patternFrame);
            SqlLiteral interval = pattern.interval;
            if (interval != null) {
                writer.sep("WITHIN");
                interval.unparse(writer, 0, 0);
            }
            if (!pattern.subsetList.isEmpty()) {
                writer.newlineAndIndent();
                writer.sep("SUBSET");
                SqlWriter.Frame subsetFrame = writer.startList("", "");
                pattern.subsetList.unparse(writer, 0, 0);
                writer.endList(subsetFrame);
            }
            writer.newlineAndIndent();
            writer.sep("DEFINE");
            SqlWriter.Frame patternDefFrame = writer.startList("", "");
            SqlNodeList newDefineList = new SqlNodeList(SqlParserPos.ZERO);
            for (SqlNode node : pattern.getPatternDefList()) {
                SqlCall call2 = (SqlCall)node;
                newDefineList.add(call2.getOperator().createCall(SqlParserPos.ZERO, new SqlNode[]{call2.operand(1), call2.operand(0)}));
            }
            newDefineList.unparse(writer, 0, 0);
            writer.endList(patternDefFrame);
            writer.endList(mrFrame);
        }
    }

    public static enum AfterOption implements Symbolizable
    {
        SKIP_TO_NEXT_ROW("SKIP TO NEXT ROW"),
        SKIP_PAST_LAST_ROW("SKIP PAST LAST ROW");

        private final String sql;

        private AfterOption(String sql) {
            this.sql = sql;
        }

        public String toString() {
            return this.sql;
        }
    }

    public static enum RowsPerMatchOption {
        ONE_ROW("ONE ROW PER MATCH"),
        ALL_ROWS("ALL ROWS PER MATCH");

        private final String sql;

        private RowsPerMatchOption(String sql) {
            this.sql = sql;
        }

        public String toString() {
            return this.sql;
        }

        public SqlLiteral symbol(SqlParserPos pos) {
            return SqlLiteral.createSymbol(this, pos);
        }
    }
}

