/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rex;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.util.Litmus;
import org.checkerframework.checker.nullness.qual.Nullable;

public class RexChecker
extends RexVisitorImpl<Boolean> {
    protected final @Nullable RelNode.Context context;
    protected final Litmus litmus;
    protected final List<RelDataType> inputTypeList;
    protected int failCount;

    public RexChecker(RelDataType inputRowType, @Nullable RelNode.Context context, Litmus litmus) {
        this(RelOptUtil.getFieldTypeList(inputRowType), context, litmus);
    }

    public RexChecker(List<RelDataType> inputTypeList, @Nullable RelNode.Context context, Litmus litmus) {
        super(true);
        this.inputTypeList = inputTypeList;
        this.context = context;
        this.litmus = litmus;
    }

    public int getFailureCount() {
        return this.failCount;
    }

    @Override
    public Boolean visitInputRef(RexInputRef ref) {
        int index = ref.getIndex();
        if (index < 0 || index >= this.inputTypeList.size()) {
            ++this.failCount;
            return this.litmus.fail("RexInputRef index {} out of range 0..{}", index, this.inputTypeList.size() - 1);
        }
        if (!ref.getType().isStruct() && !RelOptUtil.eq("ref", ref.getType(), "input", this.inputTypeList.get(index), this.litmus)) {
            ++this.failCount;
            return this.litmus.fail(null, new Object[0]);
        }
        return this.litmus.succeed();
    }

    @Override
    public Boolean visitLocalRef(RexLocalRef ref) {
        ++this.failCount;
        return this.litmus.fail("RexLocalRef illegal outside program", new Object[0]);
    }

    @Override
    public Boolean visitCall(RexCall call) {
        for (RexNode operand : call.getOperands()) {
            Boolean valid = operand.accept(this);
            if (valid == null || valid.booleanValue()) continue;
            return this.litmus.fail(null, new Object[0]);
        }
        return this.litmus.succeed();
    }

    @Override
    public Boolean visitFieldAccess(RexFieldAccess fieldAccess) {
        super.visitFieldAccess(fieldAccess);
        RelDataType refType = fieldAccess.getReferenceExpr().getType();
        assert (refType.isStruct());
        RelDataTypeField field = fieldAccess.getField();
        int index = field.getIndex();
        if (index < 0 || index >= refType.getFieldList().size()) {
            ++this.failCount;
            return this.litmus.fail(null, new Object[0]);
        }
        RelDataTypeField typeField = refType.getFieldList().get(index);
        if (!RelOptUtil.eq("type1", typeField.getType(), "type2", fieldAccess.getType(), this.litmus)) {
            ++this.failCount;
            return this.litmus.fail(null, new Object[0]);
        }
        return this.litmus.succeed();
    }

    @Override
    public Boolean visitCorrelVariable(RexCorrelVariable v) {
        if (this.context != null && !this.context.correlationIds().contains(v.id)) {
            ++this.failCount;
            return this.litmus.fail("correlation id {} not found in correlation list {}", v, this.context.correlationIds());
        }
        return this.litmus.succeed();
    }

    public final boolean isValid(RexNode expr) {
        return Objects.requireNonNull(expr.accept(this), () -> "expr.accept(RexChecker) for expr=" + expr);
    }
}

