/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.List;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.rules.ImmutableConfig;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.tools.RelBuilder;
import org.immutables.value.Value;

public class ProjectOverSumToSum0Rule
extends RelRule<Config>
implements TransformationRule {
    protected ProjectOverSumToSum0Rule(Config config) {
        super(config);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Project project = (Project)call.rel(0);
        assert (project.containsOver());
        RexShuttle sumToSum0 = new RexShuttle(){

            @Override
            public SqlAggFunction visitOverAggFunction(SqlAggFunction op) {
                if (op == SqlStdOperatorTable.SUM) {
                    return SqlStdOperatorTable.SUM0;
                }
                return op;
            }
        };
        List topProjExps = sumToSum0.visitList(project.getProjects());
        RelBuilder relBuilder = call.builder();
        relBuilder.push(project.getInput());
        relBuilder.project(topProjExps, project.getRowType().getFieldNames());
        call.transformTo(relBuilder.build());
    }

    private static boolean projectContainsOverWithSum(Project project) {
        if (project.containsOver()) {
            HaveOverWithSumRexShuttle rexShuttle = new HaveOverWithSumRexShuttle();
            rexShuttle.visitList(project.getProjects());
            return rexShuttle.haveOverWithSum;
        }
        return false;
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableConfig.of().withOperandSupplier(b -> b.operand(Project.class).predicate(x$0 -> ProjectOverSumToSum0Rule.projectContainsOverWithSum(x$0)).anyInputs()).withDescription("ProjectOverSumToSum0Rule");

        @Override
        default public ProjectOverSumToSum0Rule toRule() {
            return new ProjectOverSumToSum0Rule(this);
        }
    }

    private static class HaveOverWithSumRexShuttle
    extends RexShuttle {
        private boolean haveOverWithSum;

        private HaveOverWithSumRexShuttle() {
        }

        @Override
        public SqlAggFunction visitOverAggFunction(SqlAggFunction op) {
            if (op == SqlStdOperatorTable.SUM) {
                this.haveOverWithSum = true;
            }
            return op;
        }
    }
}

