/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.interpreter;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.calcite.interpreter.AbstractSingleNode;
import org.apache.calcite.interpreter.Compiler;
import org.apache.calcite.interpreter.Row;
import org.apache.calcite.rel.core.Uncollect;

public class UncollectNode
extends AbstractSingleNode<Uncollect> {
    public UncollectNode(Compiler compiler, Uncollect uncollect) {
        super(compiler, uncollect);
    }

    @Override
    public void run() throws InterruptedException {
        Row row = null;
        while ((row = this.source.receive()) != null) {
            for (Object value : row.getValues()) {
                if (value == null) {
                    throw new NullPointerException("NULL value for unnest.");
                }
                int i = 1;
                if (value instanceof List) {
                    List list = (List)value;
                    for (Object o : list) {
                        if (((Uncollect)this.rel).withOrdinality) {
                            this.sink.send(Row.of(o, (Object)i++));
                            continue;
                        }
                        this.sink.send(Row.of(o));
                    }
                    continue;
                }
                if (value instanceof Map) {
                    Map map = (Map)value;
                    for (Object key : map.keySet()) {
                        if (((Uncollect)this.rel).withOrdinality) {
                            this.sink.send(Row.of(key, map.get(key), (Object)i++));
                            continue;
                        }
                        this.sink.send(Row.of(key, map.get(key)));
                    }
                    continue;
                }
                throw new UnsupportedOperationException(String.format(Locale.ROOT, "Invalid type: %s for unnest.", value.getClass().getCanonicalName()));
            }
        }
    }
}

