/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.adapter.enumerable.EnumUtils;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.interpreter.Row;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.IndexExpression;
import org.apache.calcite.linq4j.tree.MemberExpression;
import org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.linq4j.tree.PseudoField;
import org.apache.calcite.linq4j.tree.Statement;
import org.apache.calcite.linq4j.tree.Types;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.runtime.FlatLists;
import org.apache.calcite.runtime.Unit;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.BuiltInMethod;
import org.checkerframework.checker.nullness.qual.Nullable;

public enum JavaRowFormat {
    CUSTOM{

        @Override
        Type javaRowClass(JavaTypeFactory typeFactory, RelDataType type) {
            assert (type.getFieldCount() > 1);
            return typeFactory.getJavaClass(type);
        }

        @Override
        Type javaFieldClass(JavaTypeFactory typeFactory, RelDataType type, int index) {
            return typeFactory.getJavaClass(type.getFieldList().get(index).getType());
        }

        @Override
        public Expression record(Type javaRowClass, List<Expression> expressions) {
            switch (expressions.size()) {
                case 0: {
                    assert (javaRowClass == Unit.class);
                    return Expressions.field(null, (Type)javaRowClass, (String)"INSTANCE");
                }
            }
            return Expressions.new_((Type)javaRowClass, expressions);
        }

        public MemberExpression field(Expression expression, int field, @Nullable Type fromType, Type fieldType) {
            Type type = expression.getType();
            if (type instanceof Types.RecordType) {
                Types.RecordType recordType = (Types.RecordType)type;
                Types.RecordField recordField = (Types.RecordField)recordType.getRecordFields().get(field);
                return Expressions.field((Expression)expression, (Type)recordField.getDeclaringClass(), (String)recordField.getName());
            }
            return Expressions.field((Expression)expression, (PseudoField)Types.nthField((int)field, (Type)type));
        }

        @Override
        public List<Statement> copy(ParameterExpression parameter, ParameterExpression outputArray, int outputStartIndex, int length) {
            ArrayList<Statement> statements = new ArrayList<Statement>(length);
            for (int i = 0; i < length; ++i) {
                statements.add(Expressions.statement((Expression)Expressions.assign((Expression)Expressions.arrayIndex((Expression)outputArray, (Expression)Expressions.constant((Object)(outputStartIndex + i))), (Expression)this.field((Expression)parameter, i, null, (Type)((Object)Object.class)))));
            }
            return statements;
        }
    }
    ,
    SCALAR{

        @Override
        Type javaRowClass(JavaTypeFactory typeFactory, RelDataType type) {
            assert (type.getFieldCount() == 1);
            RelDataType field0Type = type.getFieldList().get(0).getType();
            if (field0Type.getSqlTypeName() == SqlTypeName.ROW) {
                return Object[].class;
            }
            return typeFactory.getJavaClass(type.getFieldList().get(0).getType());
        }

        @Override
        Type javaFieldClass(JavaTypeFactory typeFactory, RelDataType type, int index) {
            return this.javaRowClass(typeFactory, type);
        }

        @Override
        public Expression record(Type javaRowClass, List<Expression> expressions) {
            assert (expressions.size() == 1);
            return expressions.get(0);
        }

        @Override
        public Expression field(Expression expression, int field, @Nullable Type fromType, Type fieldType) {
            assert (field == 0);
            return expression;
        }

        @Override
        public List<Statement> copy(ParameterExpression parameter, ParameterExpression outputArray, int outputStartIndex, int length) {
            assert (length == 1);
            return FlatLists.of(Expressions.statement((Expression)Expressions.assign((Expression)Expressions.arrayIndex((Expression)outputArray, (Expression)Expressions.constant((Object)outputStartIndex)), (Expression)parameter)));
        }
    }
    ,
    LIST{

        @Override
        Type javaRowClass(JavaTypeFactory typeFactory, RelDataType type) {
            return FlatLists.ComparableList.class;
        }

        @Override
        Type javaFieldClass(JavaTypeFactory typeFactory, RelDataType type, int index) {
            return Object.class;
        }

        @Override
        public Expression record(Type javaRowClass, List<Expression> expressions) {
            switch (expressions.size()) {
                case 0: {
                    return Expressions.field(null, FlatLists.class, (String)"COMPARABLE_EMPTY_LIST");
                }
                case 2: {
                    return Expressions.convert_((Expression)Expressions.call(List.class, null, (Method)BuiltInMethod.LIST2.method, expressions), List.class);
                }
                case 3: {
                    return Expressions.convert_((Expression)Expressions.call(List.class, null, (Method)BuiltInMethod.LIST3.method, expressions), List.class);
                }
                case 4: {
                    return Expressions.convert_((Expression)Expressions.call(List.class, null, (Method)BuiltInMethod.LIST4.method, expressions), List.class);
                }
                case 5: {
                    return Expressions.convert_((Expression)Expressions.call(List.class, null, (Method)BuiltInMethod.LIST5.method, expressions), List.class);
                }
                case 6: {
                    return Expressions.convert_((Expression)Expressions.call(List.class, null, (Method)BuiltInMethod.LIST6.method, expressions), List.class);
                }
            }
            return Expressions.convert_((Expression)Expressions.call(List.class, null, (Method)BuiltInMethod.LIST_N.method, (Expression[])new Expression[]{Expressions.newArrayInit(Comparable.class, expressions)}), List.class);
        }

        @Override
        public Expression field(Expression expression, int field, @Nullable Type fromType, Type fieldType) {
            MethodCallExpression e = Expressions.call((Expression)expression, (Method)BuiltInMethod.LIST_GET.method, (Expression[])new Expression[]{Expressions.constant((Object)field)});
            if (fromType == null) {
                fromType = e.getType();
            }
            return EnumUtils.convert((Expression)e, fromType, fieldType);
        }

        @Override
        public List<Statement> copy(ParameterExpression parameter, ParameterExpression outputArray, int outputStartIndex, int length) {
            return FlatLists.of(Expressions.statement((Expression)Expressions.call((Method)BuiltInMethod.ARRAY_COPY.method, (Expression[])new Expression[]{Expressions.call((Expression)parameter, (Method)BuiltInMethod.LIST_TO_ARRAY.method, (Expression[])new Expression[0]), Expressions.constant((Object)0), outputArray, Expressions.constant((Object)outputStartIndex), Expressions.constant((Object)length)})));
        }
    }
    ,
    ROW{

        @Override
        Type javaRowClass(JavaTypeFactory typeFactory, RelDataType type) {
            return Row.class;
        }

        @Override
        Type javaFieldClass(JavaTypeFactory typeFactory, RelDataType type, int index) {
            return Object.class;
        }

        @Override
        public Expression record(Type javaRowClass, List<Expression> expressions) {
            return Expressions.call((Method)BuiltInMethod.ROW_AS_COPY.method, expressions);
        }

        @Override
        public Expression field(Expression expression, int field, @Nullable Type fromType, Type fieldType) {
            MethodCallExpression e = Expressions.call((Expression)expression, (Method)BuiltInMethod.ROW_VALUE.method, (Expression[])new Expression[]{Expressions.constant((Object)field)});
            if (fromType == null) {
                fromType = e.getType();
            }
            return EnumUtils.convert((Expression)e, fromType, fieldType);
        }

        @Override
        public List<Statement> copy(ParameterExpression parameter, ParameterExpression outputArray, int outputStartIndex, int length) {
            return FlatLists.of(Expressions.statement((Expression)Expressions.call((Method)BuiltInMethod.ARRAY_COPY.method, (Expression[])new Expression[]{Expressions.call(Object[].class, (Expression)parameter, (Method)BuiltInMethod.ROW_COPY_VALUES.method, (Expression[])new Expression[0]), Expressions.constant((Object)0), outputArray, Expressions.constant((Object)outputStartIndex), Expressions.constant((Object)length)})));
        }
    }
    ,
    ARRAY{

        @Override
        Type javaRowClass(JavaTypeFactory typeFactory, RelDataType type) {
            return Object[].class;
        }

        @Override
        Type javaFieldClass(JavaTypeFactory typeFactory, RelDataType type, int index) {
            return Object.class;
        }

        @Override
        public Expression record(Type javaRowClass, List<Expression> expressions) {
            return Expressions.newArrayInit(Object.class, expressions);
        }

        @Override
        public Expression comparer() {
            return Expressions.call((Method)BuiltInMethod.ARRAY_COMPARER.method, (Expression[])new Expression[0]);
        }

        @Override
        public Expression field(Expression expression, int field, @Nullable Type fromType, Type fieldType) {
            IndexExpression e = Expressions.arrayIndex((Expression)expression, (Expression)Expressions.constant((Object)field));
            if (fromType == null) {
                fromType = e.getType();
            }
            return EnumUtils.convert((Expression)e, fromType, fieldType);
        }

        @Override
        public List<Statement> copy(ParameterExpression parameter, ParameterExpression outputArray, int outputStartIndex, int length) {
            return FlatLists.of(Expressions.statement((Expression)Expressions.call((Method)BuiltInMethod.ARRAY_COPY.method, (Expression[])new Expression[]{parameter, Expressions.constant((Object)0), outputArray, Expressions.constant((Object)outputStartIndex), Expressions.constant((Object)length)})));
        }
    };


    public JavaRowFormat optimize(RelDataType rowType) {
        switch (rowType.getFieldCount()) {
            case 0: {
                return LIST;
            }
            case 1: {
                return SCALAR;
            }
        }
        if (this == SCALAR) {
            return LIST;
        }
        return this;
    }

    abstract Type javaRowClass(JavaTypeFactory var1, RelDataType var2);

    abstract Type javaFieldClass(JavaTypeFactory var1, RelDataType var2, int var3);

    public abstract Expression record(Type var1, List<Expression> var2);

    public @Nullable Expression comparer() {
        return null;
    }

    public abstract Expression field(Expression var1, int var2, @Nullable Type var3, Type var4);

    public abstract List<Statement> copy(ParameterExpression var1, ParameterExpression var2, int var3, int var4);
}

