/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.calcite.adapter.enumerable.EnumUtils;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.adapter.enumerable.EnumerableTraitsUtils;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AsofJoin;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.metadata.RelMdCollation;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.Pair;
import org.checkerframework.checker.nullness.qual.Nullable;

public class EnumerableAsofJoin
extends AsofJoin
implements EnumerableRel {
    protected EnumerableAsofJoin(RelOptCluster cluster, RelTraitSet traits, RelNode left, RelNode right, RexNode condition, RexNode matchCondition, Set<CorrelationId> variablesSet, JoinRelType joinType) {
        super(cluster, traits, (List<RelHint>)ImmutableList.of(), left, right, condition, matchCondition, variablesSet, joinType);
    }

    public static EnumerableAsofJoin create(RelNode left, RelNode right, RexNode condition, RexNode matchCondition, Set<CorrelationId> variablesSet, JoinRelType joinType) {
        RelOptCluster cluster = left.getCluster();
        RelMetadataQuery mq = cluster.getMetadataQuery();
        RelTraitSet traitSet = cluster.traitSetOf((RelTrait)EnumerableConvention.INSTANCE).replaceIfs(RelCollationTraitDef.INSTANCE, () -> RelMdCollation.enumerableHashJoin(mq, left, right, joinType));
        return new EnumerableAsofJoin(cluster, traitSet, left, right, condition, matchCondition, variablesSet, joinType);
    }

    @Override
    public EnumerableAsofJoin copy(RelTraitSet traitSet, RexNode condition, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
        throw new RuntimeException("This method should not be called");
    }

    @Override
    public Join copy(RelTraitSet traitSet, List<RelNode> inputs) {
        assert (inputs.size() == 2);
        return new EnumerableAsofJoin(this.getCluster(), traitSet, inputs.get(0), inputs.get(1), this.getCondition(), this.matchCondition, (Set<CorrelationId>)this.variablesSet, this.joinType);
    }

    @Override
    public @Nullable Pair<RelTraitSet, List<RelTraitSet>> passThroughTraits(RelTraitSet required) {
        return EnumerableTraitsUtils.passThroughTraitsForJoin(required, this.joinType, this.left.getRowType().getFieldCount(), this.getTraitSet());
    }

    @Override
    public @Nullable Pair<RelTraitSet, List<RelTraitSet>> deriveTraits(RelTraitSet childTraits, int childId) {
        return EnumerableTraitsUtils.deriveTraitsForJoin(childTraits, childId, this.joinType, this.getTraitSet(), this.right.getTraitSet());
    }

    @Override
    public @Nullable RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double rowCount = mq.getRowCount(this);
        return planner.getCostFactory().makeCost(rowCount, 0.0, 0.0);
    }

    private static Expression generateTimestampComparator(PhysType rightCollectionType, SqlKind kind, int timestampFieldIndex) {
        RelFieldCollation.Direction direction;
        switch (kind) {
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: {
                direction = RelFieldCollation.Direction.ASCENDING;
                break;
            }
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: {
                direction = RelFieldCollation.Direction.DESCENDING;
                break;
            }
            default: {
                throw new RuntimeException("Unexpected timestamp comparison in ASOF join " + (Object)((Object)kind));
            }
        }
        ArrayList<RelFieldCollation> fieldCollations = new ArrayList<RelFieldCollation>(1);
        fieldCollations.add(new RelFieldCollation(timestampFieldIndex, direction, RelFieldCollation.NullDirection.FIRST));
        RelCollation collation = RelCollations.of(fieldCollations);
        return rightCollectionType.generateComparator(collation);
    }

    private int getTimestampFieldIndex(RexCall call) {
        int leftFieldCount = this.left.getRowType().getFieldCount();
        List<RexNode> operands = call.getOperands();
        assert (operands.size() == 2);
        RexNode compareLeft = operands.get(0);
        RexNode compareRight = operands.get(1);
        assert (compareLeft instanceof RexInputRef);
        assert (compareRight instanceof RexInputRef);
        RexInputRef leftInputRef = (RexInputRef)compareLeft;
        RexInputRef rightInputRef = (RexInputRef)compareRight;
        int timestampFieldIndex = leftInputRef.getIndex() < leftFieldCount ? rightInputRef.getIndex() - leftFieldCount : leftInputRef.getIndex() - leftFieldCount;
        return timestampFieldIndex;
    }

    @Override
    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        BlockBuilder builder = new BlockBuilder();
        EnumerableRel.Result leftResult = implementor.visitChild(this, 0, (EnumerableRel)this.left, pref);
        Expression leftExpression = builder.append("left", leftResult.block);
        EnumerableRel.Result rightResult = implementor.visitChild(this, 1, (EnumerableRel)this.right, pref);
        Expression rightExpression = builder.append("right", rightResult.block);
        PhysType physType = PhysTypeImpl.of(implementor.getTypeFactory(), this.getRowType(), pref.preferArray());
        assert (this.joinInfo.nonEquiConditions.isEmpty());
        assert (this.matchCondition instanceof RexCall);
        RexCall call = (RexCall)this.matchCondition;
        SqlKind kind = call.getKind();
        int timestampFieldIndex = this.getTimestampFieldIndex(call);
        Expression timestampComparator = EnumerableAsofJoin.generateTimestampComparator(rightResult.physType, kind, timestampFieldIndex);
        Expression matchPredicate = EnumUtils.generatePredicate(implementor, this.getCluster().getRexBuilder(), this.left, this.right, leftResult.physType, rightResult.physType, this.matchCondition);
        return implementor.result(physType, builder.append((Expression)Expressions.call((Expression)leftExpression, (Method)BuiltInMethod.ASOF_JOIN.method, (Iterable)Expressions.list((Object[])new Expression[]{rightExpression, leftResult.physType.generateAccessorWithoutNulls(this.joinInfo.leftKeys), rightResult.physType.generateAccessorWithoutNulls(this.joinInfo.rightKeys), EnumUtils.joinSelector(this.joinType, physType, (List<PhysType>)ImmutableList.of((Object)leftResult.physType, (Object)rightResult.physType))}).append((Object)matchPredicate).append((Object)timestampComparator).append((Object)Expressions.constant((Object)this.joinType.generatesNullsOnRight())))).toBlock());
    }
}

