/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.client.handler.requests.sql;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite.client.handler.ClientResourceRegistry;
import org.apache.ignite.client.handler.requests.sql.ClientSqlCommon;
import org.apache.ignite.client.handler.requests.sql.ClientSqlResultSet;
import org.apache.ignite.internal.client.proto.ClientMessagePacker;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.sql.SqlRow;
import org.apache.ignite.sql.async.AsyncResultSet;

public class ClientSqlCursorNextPageRequest {
    public static CompletableFuture<Void> process(ClientMessageUnpacker in, ClientMessagePacker out, ClientResourceRegistry resources) throws IgniteInternalCheckedException {
        long resourceId = in.unpackLong();
        ClientSqlResultSet resultSet = resources.get(resourceId).get(ClientSqlResultSet.class);
        return ((CompletableFuture)resultSet.resultSet().fetchNextPage().thenCompose(r -> {
            ClientSqlCommon.packCurrentPage(out, (AsyncResultSet<SqlRow>)r);
            out.packBoolean(r.hasMorePages());
            if (!r.hasMorePages()) {
                try {
                    resources.remove(resourceId);
                }
                catch (IgniteInternalCheckedException igniteInternalCheckedException) {
                    // empty catch block
                }
                return resultSet.closeAsync();
            }
            return CompletableFutures.nullCompletedFuture();
        })).toCompletableFuture();
    }
}

