/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.restart;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.Ignite;
import org.apache.ignite.catalog.IgniteCatalog;
import org.apache.ignite.compute.IgniteCompute;
import org.apache.ignite.internal.restart.IgniteAttachmentLock;
import org.apache.ignite.internal.restart.RestartProofIgniteCatalog;
import org.apache.ignite.internal.restart.RestartProofIgniteCompute;
import org.apache.ignite.internal.restart.RestartProofIgniteSql;
import org.apache.ignite.internal.restart.RestartProofIgniteTables;
import org.apache.ignite.internal.restart.RestartProofIgniteTransactions;
import org.apache.ignite.internal.wrapper.Wrapper;
import org.apache.ignite.network.ClusterNode;
import org.apache.ignite.sql.IgniteSql;
import org.apache.ignite.table.IgniteTables;
import org.apache.ignite.tx.IgniteTransactions;

public class RestartProofIgnite
implements Ignite,
Wrapper {
    private final IgniteAttachmentLock attachmentLock;
    private final IgniteTables tables;
    private final IgniteTransactions transactions;
    private final IgniteSql sql;
    private final IgniteCompute compute;
    private final IgniteCatalog catalog;

    public RestartProofIgnite(IgniteAttachmentLock attachmentLock) {
        this.attachmentLock = attachmentLock;
        this.tables = new RestartProofIgniteTables(attachmentLock);
        this.transactions = new RestartProofIgniteTransactions(attachmentLock);
        this.sql = new RestartProofIgniteSql(attachmentLock);
        this.compute = new RestartProofIgniteCompute(attachmentLock);
        this.catalog = new RestartProofIgniteCatalog(attachmentLock);
    }

    public String name() {
        return this.attachmentLock.attached(Ignite::name);
    }

    public IgniteTables tables() {
        return this.tables;
    }

    public IgniteTransactions transactions() {
        return this.transactions;
    }

    public IgniteSql sql() {
        return this.sql;
    }

    public IgniteCompute compute() {
        return this.compute;
    }

    public Collection<ClusterNode> clusterNodes() {
        return this.attachmentLock.attached(Ignite::clusterNodes);
    }

    public CompletableFuture<Collection<ClusterNode>> clusterNodesAsync() {
        return this.attachmentLock.attachedAsync(Ignite::clusterNodesAsync);
    }

    public IgniteCatalog catalog() {
        return this.catalog;
    }

    public <T> T unwrap(Class<T> classToUnwrap) {
        return (T)this.attachmentLock.attached(classToUnwrap::cast);
    }
}

