/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.trace;

import io.opentelemetry.exporter.internal.grpc.GrpcExporter;
import io.opentelemetry.exporter.internal.grpc.GrpcExporterBuilder;
import io.opentelemetry.exporter.internal.marshal.Marshaler;
import io.opentelemetry.exporter.internal.otlp.traces.SpanReusableDataMarshaler;
import io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporterBuilder;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.common.export.MemoryMode;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.Collection;
import java.util.StringJoiner;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class OtlpGrpcSpanExporter
implements SpanExporter {
    private final GrpcExporterBuilder<Marshaler> builder;
    private final GrpcExporter<Marshaler> delegate;
    private final SpanReusableDataMarshaler marshaler;

    public static OtlpGrpcSpanExporter getDefault() {
        return OtlpGrpcSpanExporter.builder().build();
    }

    public static OtlpGrpcSpanExporterBuilder builder() {
        return new OtlpGrpcSpanExporterBuilder();
    }

    OtlpGrpcSpanExporter(GrpcExporterBuilder<Marshaler> builder, GrpcExporter<Marshaler> delegate, MemoryMode memoryMode) {
        this.builder = builder;
        this.delegate = delegate;
        this.marshaler = new SpanReusableDataMarshaler(memoryMode, (arg_0, arg_1) -> delegate.export(arg_0, arg_1));
    }

    public OtlpGrpcSpanExporterBuilder toBuilder() {
        return new OtlpGrpcSpanExporterBuilder((GrpcExporterBuilder<Marshaler>)this.builder.copy(), this.marshaler.getMemoryMode());
    }

    public CompletableResultCode export(Collection<SpanData> spans) {
        return this.marshaler.export(spans);
    }

    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode shutdown() {
        return this.delegate.shutdown();
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ", "OtlpGrpcSpanExporter{", "}");
        joiner.add(this.builder.toString(false));
        joiner.add("memoryMode=" + this.marshaler.getMemoryMode());
        return joiner.toString();
    }
}

