/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.exceptions;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.exceptions.HttpException;

public class HttpClientException
extends HttpException {
    private String serviceId;
    private boolean serviceIdLocked;

    public HttpClientException(String message) {
        super(message);
    }

    public HttpClientException(String message, Throwable cause) {
        super(message, cause);
    }

    public HttpClientException(String message, Throwable cause, boolean shared) {
        super(message, cause, false, true);
        if (!shared) {
            throw new IllegalArgumentException("shared must be true");
        }
        this.serviceIdLocked = true;
    }

    @Nullable
    public final String getServiceId() {
        return this.serviceId;
    }

    @Internal
    public final void setServiceId(String serviceId) {
        if (this.serviceIdLocked) {
            throw new IllegalStateException("Service ID already set");
        }
        this.serviceId = serviceId;
        this.serviceIdLocked = true;
    }

    public String getMessage() {
        if (this.serviceId != null) {
            return "Client '" + this.serviceId + "': " + super.getMessage();
        }
        return super.getMessage();
    }
}

