/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.util;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.apache.ignite.internal.configuration.tree.ConfigurationVisitor;
import org.apache.ignite.internal.configuration.tree.InnerNode;
import org.apache.ignite.internal.configuration.tree.NamedListNode;
import org.apache.ignite.internal.configuration.util.ConfigurationUtil;

public abstract class KeysTrackingConfigurationVisitor<T>
implements ConfigurationVisitor<T> {
    private final StringBuilder currentKey = new StringBuilder();
    private final List<String> currentPath = new ArrayList<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final T visitLeafNode(Field field, String key, Serializable val) {
        int prevPos = this.startVisit(key, false, true);
        try {
            T t = this.doVisitLeafNode(field, key, val);
            return t;
        }
        finally {
            this.endVisit(prevPos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final T visitInnerNode(Field field, String key, InnerNode node) {
        int prevPos = this.startVisit(key, false, false);
        try {
            T t = this.doVisitInnerNode(field, key, node);
            return t;
        }
        finally {
            this.endVisit(prevPos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final T visitNamedListNode(Field field, String key, NamedListNode<?> node) {
        int prevPos = this.startVisit(key, false, false);
        try {
            T t = this.doVisitNamedListNode(field, key, node);
            return t;
        }
        finally {
            this.endVisit(prevPos);
        }
    }

    protected T doVisitLeafNode(Field field, String key, Serializable val) {
        return null;
    }

    protected T doVisitInnerNode(Field field, String key, InnerNode node) {
        node.traverseChildren(this, true);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T doVisitNamedListNode(Field field, String key, NamedListNode<?> node) {
        for (String namedListKey : node.namedListKeys()) {
            int prevPos = this.startVisit(namedListKey, true, false);
            try {
                this.doVisitInnerNode(field, namedListKey, node.getInnerNode(namedListKey));
            }
            finally {
                this.endVisit(prevPos);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final T withTracking(String key, boolean escape, boolean leaf, Supplier<T> closure) {
        int prevPos = this.startVisit(key, escape, leaf);
        try {
            T t = closure.get();
            return t;
        }
        finally {
            this.endVisit(prevPos);
        }
    }

    protected final String currentKey() {
        return this.currentKey.toString();
    }

    protected final List<String> currentPath() {
        return Collections.unmodifiableList(this.currentPath);
    }

    private int startVisit(String key, boolean escape, boolean leaf) {
        int previousKeyLength = this.currentKey.length();
        this.currentKey.append(escape ? ConfigurationUtil.escape(key) : key);
        if (!leaf) {
            this.currentKey.append('.');
        }
        this.currentPath.add(key);
        return previousKeyLength;
    }

    private void endVisit(int previousKeyLength) {
        this.currentKey.setLength(previousKeyLength);
        this.currentPath.remove(this.currentPath.size() - 1);
    }
}

