/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.tree;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.ignite.configuration.ConfigurationNodeAlreadyExistException;
import org.apache.ignite.configuration.ConfigurationNodeDoesNotExistException;
import org.apache.ignite.configuration.ConfigurationNodeRemovedException;
import org.apache.ignite.configuration.NamedListChange;
import org.apache.ignite.internal.configuration.tree.ConfigurationSource;
import org.apache.ignite.internal.configuration.tree.ConfigurationVisitor;
import org.apache.ignite.internal.configuration.tree.ConstructableTreeNode;
import org.apache.ignite.internal.configuration.tree.InnerNode;
import org.apache.ignite.internal.configuration.tree.OrderedMap;
import org.apache.ignite.internal.configuration.tree.TraversableTreeNode;
import org.apache.ignite.internal.configuration.util.ConfigurationUtil;
import org.jetbrains.annotations.Nullable;

public final class NamedListNode<N>
implements NamedListChange<N, N>,
TraversableTreeNode,
ConstructableTreeNode {
    public static final String ORDER_IDX = "<order>";
    public static final String NAME = "<name>";
    public static final String IDS = "<ids>";
    private final String syntheticKeyName;
    private final Supplier<InnerNode> valSupplier;
    private final OrderedMap<ElementDescriptor> map;
    private final Map<UUID, String> reverseIdMap;
    @Nullable
    private final String typeIdFieldName;
    private boolean immutable = false;

    public NamedListNode(String syntheticKeyName, Supplier<InnerNode> valSupplier, @Nullable String typeIdFieldName) {
        this.syntheticKeyName = syntheticKeyName;
        this.valSupplier = valSupplier;
        this.typeIdFieldName = typeIdFieldName;
        this.map = new OrderedMap();
        this.reverseIdMap = new HashMap<UUID, String>();
    }

    private NamedListNode(NamedListNode<N> node) {
        this.syntheticKeyName = node.syntheticKeyName;
        this.valSupplier = node.valSupplier;
        this.typeIdFieldName = node.typeIdFieldName;
        this.map = new OrderedMap();
        this.reverseIdMap = new HashMap<UUID, String>(node.reverseIdMap);
        for (String key : node.map.keys()) {
            this.map.put(key, node.map.get(key).shallowCopy());
        }
    }

    @Override
    public <T> T accept(Field field, String key, ConfigurationVisitor<T> visitor) {
        return visitor.visitNamedListNode(field, key, this);
    }

    public List<String> namedListKeys() {
        return Collections.unmodifiableList(this.map.keys());
    }

    public N get(String key) {
        return this.specificNode(this.map.get(key));
    }

    @Nullable
    public N get(UUID internalId) {
        return this.get(this.keyByInternalId(internalId));
    }

    public N get(int index) throws IndexOutOfBoundsException {
        return this.specificNode(this.map.get(index));
    }

    @Nullable
    public InnerNode getInnerNode(String key) {
        ElementDescriptor element = this.map.get(key);
        return element == null ? null : element.value;
    }

    public int size() {
        return this.map.size();
    }

    public Stream<N> stream() {
        return IntStream.range(0, this.map.size()).mapToObj(this.map::get).map(this::specificNode);
    }

    public NamedListChange<N, N> create(String key, Consumer<N> valConsumer) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(valConsumer, "valConsumer");
        this.assertMutability();
        this.checkNewKey(key);
        ElementDescriptor element = this.newElementDescriptor(key);
        this.map.put(key, element);
        this.reverseIdMap.put(element.internalId, key);
        valConsumer.accept(element.value);
        return this;
    }

    public NamedListChange<N, N> create(int index, String key, Consumer<N> valConsumer) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(valConsumer, "valConsumer");
        this.assertMutability();
        if (index < 0 || index > this.map.size()) {
            throw new IndexOutOfBoundsException(index);
        }
        this.checkNewKey(key);
        ElementDescriptor element = this.newElementDescriptor(key);
        this.map.putByIndex(index, key, element);
        this.reverseIdMap.put(element.internalId, key);
        valConsumer.accept(element.value);
        return this;
    }

    public NamedListChange<N, N> createAfter(String precedingKey, String key, Consumer<N> valConsumer) {
        Objects.requireNonNull(precedingKey, "precedingKey");
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(valConsumer, "valConsumer");
        this.assertMutability();
        ElementDescriptor precedingElement = this.map.get(precedingKey);
        if (precedingElement == null) {
            throw NamedListNode.elementMissingException(precedingKey);
        }
        if (precedingElement.value == null) {
            throw NamedListNode.elementRemovedException(precedingKey);
        }
        this.checkNewKey(key);
        ElementDescriptor element = this.newElementDescriptor(key);
        this.map.putAfter(precedingKey, key, element);
        this.reverseIdMap.put(element.internalId, key);
        valConsumer.accept(element.value);
        return this;
    }

    public NamedListChange<N, N> createOrUpdate(String key, Consumer<N> valConsumer) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(valConsumer, "valConsumer");
        this.assertMutability();
        ElementDescriptor element = this.map.get(key);
        if (element != null && element.value == null) {
            throw NamedListNode.elementRemovedException(key);
        }
        if (element == null) {
            element = this.newElementDescriptor(key);
            this.reverseIdMap.put(element.internalId, key);
        } else {
            element = element.copy();
        }
        this.map.put(key, element);
        valConsumer.accept(element.value);
        return this;
    }

    public NamedListChange<N, N> update(String key, Consumer<N> valConsumer) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(valConsumer, "valConsumer");
        this.assertMutability();
        ElementDescriptor element = this.map.get(key);
        if (element == null) {
            throw NamedListNode.elementMissingException(key);
        }
        if (element.value == null) {
            throw NamedListNode.elementRemovedException(key);
        }
        element = element.copy();
        this.map.put(key, element);
        valConsumer.accept(element.value);
        return this;
    }

    public NamedListChange<N, N> rename(String oldKey, String newKey) {
        Objects.requireNonNull(oldKey, "oldKey");
        Objects.requireNonNull(newKey, "newKey");
        this.assertMutability();
        if (oldKey.equals(newKey)) {
            return this;
        }
        ElementDescriptor element = this.map.get(oldKey);
        if (element == null) {
            throw NamedListNode.elementMissingException(oldKey);
        }
        if (element.value == null) {
            throw NamedListNode.elementRemovedException(oldKey);
        }
        element = element.copy();
        this.checkNewKey(newKey);
        this.map.rename(oldKey, newKey);
        this.map.put(newKey, element);
        this.reverseIdMap.put(element.internalId, newKey);
        element.value.setInjectedNameFieldValue(newKey);
        return this;
    }

    private void checkNewKey(String key) {
        ElementDescriptor element = this.map.get(key);
        if (element != null) {
            if (element.value == null) {
                throw NamedListNode.elementRemovedException(key);
            }
            throw NamedListNode.elementExistsException(key);
        }
    }

    public NamedListChange<N, N> delete(String key) {
        Objects.requireNonNull(key, "key");
        this.assertMutability();
        ElementDescriptor element = this.map.get(key);
        if (element != null) {
            element.value = null;
        }
        return this;
    }

    public String syntheticKeyName() {
        return this.syntheticKeyName;
    }

    public void setInternalId(String key, UUID internalId) {
        this.assertMutability();
        ElementDescriptor element = this.map.get(key);
        if (element != null) {
            this.reverseIdMap.remove(element.internalId);
            element.internalId = internalId;
            element.value.internalId(internalId);
            this.reverseIdMap.put(internalId, key);
        }
    }

    public UUID internalId(String key) {
        ElementDescriptor element = this.map.get(key);
        if (element == null) {
            throw NamedListNode.elementMissingException(key);
        }
        return element.internalId;
    }

    public String keyByInternalId(UUID internalId) {
        return this.reverseIdMap.get(internalId);
    }

    public Collection<UUID> internalIds() {
        return Collections.unmodifiableSet(this.reverseIdMap.keySet());
    }

    public void forceDelete(String key) {
        this.assertMutability();
        ElementDescriptor removed = this.map.remove(key);
        if (removed != null) {
            this.reverseIdMap.remove(removed.internalId);
        }
    }

    public void reorderKeys(List<String> orderedKeys) {
        this.assertMutability();
        this.map.reorderKeys(orderedKeys);
    }

    @Override
    public void construct(String key, ConfigurationSource src, boolean includeInternal) {
        Objects.requireNonNull(key, "key");
        this.assertMutability();
        if (src == null) {
            this.delete(key);
        } else {
            InnerNode polymorphicInnerNode;
            ElementDescriptor element = this.map.get(key);
            if (element != null && element.value == null) {
                throw NamedListNode.elementRemovedException(key);
            }
            if (element == null) {
                element = this.newElementDescriptor(key);
                this.reverseIdMap.put(element.internalId, key);
                if (this.typeIdFieldName != null) {
                    polymorphicInnerNode = element.value;
                    String polymorphicTypeId = src.polymorphicTypeId(this.typeIdFieldName);
                    if (polymorphicTypeId != null) {
                        polymorphicInnerNode.construct(this.typeIdFieldName, new ConfigurationUtil.LeafConfigurationSource((Serializable)((Object)polymorphicTypeId)), true);
                    } else {
                        Serializable typeIdNode = polymorphicInnerNode.traverseChild(this.typeIdFieldName, ConfigurationUtil.leafNodeVisitor(), true);
                        if (typeIdNode == null) {
                            throw new IllegalStateException("Polymorphic configuration type is not defined: " + polymorphicInnerNode.getClass().getName());
                        }
                    }
                }
            } else {
                element = element.copy();
                if (this.typeIdFieldName != null) {
                    polymorphicInnerNode = element.value;
                    String polymorphicTypeId = src.polymorphicTypeId(this.typeIdFieldName);
                    if (polymorphicTypeId != null) {
                        polymorphicInnerNode.construct(this.typeIdFieldName, new ConfigurationUtil.LeafConfigurationSource((Serializable)((Object)polymorphicTypeId)), true);
                    }
                }
            }
            this.map.put(key, element);
            InnerNode value = element.value;
            value.setInjectedNameFieldValue(key);
            src.descend(value);
        }
    }

    @Override
    public NamedListNode<N> copy() {
        return new NamedListNode<N>(this);
    }

    private void assertMutability() {
        if (this.immutable) {
            throw new AssertionError((Object)"Mutating immutable configuration");
        }
    }

    @Override
    public boolean makeImmutable() {
        boolean updated = !this.immutable;
        this.immutable = true;
        return updated;
    }

    private ElementDescriptor newElementDescriptor(String key) {
        InnerNode newElement = this.valSupplier.get();
        ConfigurationUtil.addDefaults(newElement);
        newElement.setInjectedNameFieldValue(key);
        newElement.internalId(this.generateInternalId());
        return new ElementDescriptor(newElement);
    }

    private UUID generateInternalId() {
        UUID newInternalId = UUID.randomUUID();
        while (this.reverseIdMap.containsKey(newInternalId)) {
            newInternalId = UUID.randomUUID();
        }
        return newInternalId;
    }

    @Nullable
    private N specificNode(@Nullable ElementDescriptor element) {
        if (element == null) {
            return null;
        }
        InnerNode value = element.value;
        return value == null ? null : (N)value.specificNode();
    }

    private static ConfigurationNodeDoesNotExistException elementMissingException(String key) {
        return new ConfigurationNodeDoesNotExistException(key);
    }

    private static ConfigurationNodeAlreadyExistException elementExistsException(String key) {
        return new ConfigurationNodeAlreadyExistException(key);
    }

    private static ConfigurationNodeRemovedException elementRemovedException(String key) {
        return new ConfigurationNodeRemovedException(key);
    }

    private static class ElementDescriptor {
        public UUID internalId;
        @Nullable
        public InnerNode value;

        ElementDescriptor(InnerNode value) {
            this.value = value;
            this.internalId = value.internalId();
        }

        private ElementDescriptor(UUID internalId, InnerNode value) {
            this.internalId = internalId;
            this.value = value;
        }

        public ElementDescriptor copy() {
            return new ElementDescriptor(this.internalId, this.value.copy());
        }

        public ElementDescriptor shallowCopy() {
            return new ElementDescriptor(this.internalId, this.value);
        }
    }
}

