/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigRenderOptions;
import java.util.List;
import org.apache.ignite.configuration.ConfigurationDynamicDefaultsPatcher;
import org.apache.ignite.configuration.ConfigurationModule;
import org.apache.ignite.configuration.SuperRootChange;
import org.apache.ignite.configuration.validation.ConfigurationValidationException;
import org.apache.ignite.internal.configuration.ConfigurationTreeGenerator;
import org.apache.ignite.internal.configuration.SuperRoot;
import org.apache.ignite.internal.configuration.SuperRootChangeImpl;
import org.apache.ignite.internal.configuration.hocon.HoconConverter;
import org.apache.ignite.internal.configuration.tree.ConfigurationSource;
import org.apache.ignite.internal.configuration.tree.ConverterToMapVisitor;

public class ConfigurationDynamicDefaultsPatcherImpl
implements ConfigurationDynamicDefaultsPatcher {
    private final ConfigurationModule configurationModule;
    private final ConfigurationTreeGenerator generator;

    public ConfigurationDynamicDefaultsPatcherImpl(ConfigurationModule configurationModule, ConfigurationTreeGenerator generator) {
        this.configurationModule = configurationModule;
        this.generator = generator;
    }

    public String patchWithDynamicDefaults(String hocon) {
        SuperRoot superRoot = this.convertToSuperRoot(hocon);
        SuperRootChangeImpl rootChange = new SuperRootChangeImpl(superRoot);
        this.configurationModule.patchConfigurationWithDynamicDefaults((SuperRootChange)rootChange);
        ConverterToMapVisitor visitor = ConverterToMapVisitor.builder().includeInternal(true).maskSecretValues(false).skipEmptyValues(true).build();
        ConfigRenderOptions renderOptions = ConfigRenderOptions.concise().setJson(false);
        return HoconConverter.represent(superRoot, List.of(), visitor).render(renderOptions);
    }

    private SuperRoot convertToSuperRoot(String hocon) {
        try {
            Config config = ConfigFactory.parseString((String)hocon);
            ConfigurationSource hoconSource = HoconConverter.hoconSource(config.root());
            SuperRoot superRoot = this.generator.createSuperRoot();
            hoconSource.descend(superRoot);
            return superRoot;
        }
        catch (Exception e) {
            throw new ConfigurationValidationException("Failed to parse HOCON: " + e.getMessage());
        }
    }
}

