/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.compute;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.ignite.compute.BroadcastExecution;
import org.apache.ignite.compute.BroadcastJobTarget;
import org.apache.ignite.compute.IgniteCompute;
import org.apache.ignite.compute.JobDescriptor;
import org.apache.ignite.compute.JobExecution;
import org.apache.ignite.compute.JobTarget;
import org.apache.ignite.compute.TaskDescriptor;
import org.apache.ignite.compute.task.TaskExecution;
import org.apache.ignite.internal.compute.AntiHijackBroadcastExecution;
import org.apache.ignite.internal.compute.AntiHijackJobExecution;
import org.apache.ignite.internal.compute.task.AntiHijackTaskExecution;
import org.apache.ignite.internal.wrapper.Wrapper;
import org.apache.ignite.lang.CancellationToken;
import org.jetbrains.annotations.Nullable;

public class AntiHijackIgniteCompute
implements IgniteCompute,
Wrapper {
    private final IgniteCompute compute;
    private final Executor asyncContinuationExecutor;

    public AntiHijackIgniteCompute(IgniteCompute compute, Executor asyncContinuationExecutor) {
        this.compute = compute;
        this.asyncContinuationExecutor = asyncContinuationExecutor;
    }

    public <T, R> CompletableFuture<JobExecution<R>> submitAsync(JobTarget target, JobDescriptor<T, R> descriptor, @Nullable T arg, @Nullable CancellationToken cancellationToken) {
        return this.compute.submitAsync(target, descriptor, arg, cancellationToken).thenApply(this::preventThreadHijack);
    }

    public <T, R> CompletableFuture<BroadcastExecution<R>> submitAsync(BroadcastJobTarget target, JobDescriptor<T, R> descriptor, @Nullable T arg, @Nullable CancellationToken cancellationToken) {
        return this.compute.submitAsync(target, descriptor, arg, cancellationToken).thenApply(this::preventThreadHijack);
    }

    public <T, R> R execute(JobTarget target, JobDescriptor<T, R> descriptor, @Nullable T arg, @Nullable CancellationToken cancellationToken) {
        return (R)this.compute.execute(target, descriptor, arg, cancellationToken);
    }

    public <T, R> Collection<R> execute(BroadcastJobTarget target, JobDescriptor<T, R> descriptor, @Nullable T arg, @Nullable CancellationToken cancellationToken) {
        return this.compute.execute(target, descriptor, arg, cancellationToken);
    }

    public <T, R> TaskExecution<R> submitMapReduce(TaskDescriptor<T, R> taskDescriptor, @Nullable T arg, @Nullable CancellationToken cancellationToken) {
        return new AntiHijackTaskExecution(this.compute.submitMapReduce(taskDescriptor, arg, cancellationToken), this.asyncContinuationExecutor);
    }

    public <T, R> R executeMapReduce(TaskDescriptor<T, R> taskDescriptor, @Nullable T arg, @Nullable CancellationToken cancellationToken) {
        return (R)this.compute.executeMapReduce(taskDescriptor, arg, cancellationToken);
    }

    private <T, R> JobExecution<R> preventThreadHijack(JobExecution<R> execution) {
        return new AntiHijackJobExecution<R>(execution, this.asyncContinuationExecutor);
    }

    private <T, R> BroadcastExecution<R> preventThreadHijack(BroadcastExecution<R> execution) {
        return new AntiHijackBroadcastExecution<R>(execution, this.asyncContinuationExecutor);
    }

    public <T> T unwrap(Class<T> classToUnwrap) {
        return classToUnwrap.cast(this.compute);
    }
}

