/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.bytecode;

import com.facebook.presto.bytecode.AnnotationDefinition;
import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.ClassDefinition;
import com.facebook.presto.bytecode.Comment;
import com.facebook.presto.bytecode.FieldDefinition;
import com.facebook.presto.bytecode.MethodDefinition;
import com.facebook.presto.bytecode.control.DoWhileLoop;
import com.facebook.presto.bytecode.control.FlowControl;
import com.facebook.presto.bytecode.control.ForLoop;
import com.facebook.presto.bytecode.control.IfStatement;
import com.facebook.presto.bytecode.control.SwitchStatement;
import com.facebook.presto.bytecode.control.TryCatch;
import com.facebook.presto.bytecode.control.WhileLoop;
import com.facebook.presto.bytecode.debug.DebugNode;
import com.facebook.presto.bytecode.debug.LineNumberNode;
import com.facebook.presto.bytecode.debug.LocalVariableNode;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.instruction.Constant;
import com.facebook.presto.bytecode.instruction.FieldInstruction;
import com.facebook.presto.bytecode.instruction.InstructionNode;
import com.facebook.presto.bytecode.instruction.InvokeInstruction;
import com.facebook.presto.bytecode.instruction.JumpInstruction;
import com.facebook.presto.bytecode.instruction.LabelNode;
import com.facebook.presto.bytecode.instruction.VariableInstruction;

public class BytecodeVisitor<T> {
    public T visitClass(ClassDefinition classDefinition) {
        for (AnnotationDefinition annotationDefinition : classDefinition.getAnnotations()) {
            this.visitAnnotation(classDefinition, annotationDefinition);
        }
        for (FieldDefinition fieldDefinition : classDefinition.getFields()) {
            this.visitField(classDefinition, fieldDefinition);
        }
        for (MethodDefinition methodDefinition : classDefinition.getMethods()) {
            this.visitMethod(classDefinition, methodDefinition);
        }
        return null;
    }

    public T visitAnnotation(Object parent, AnnotationDefinition annotationDefinition) {
        return null;
    }

    public T visitField(ClassDefinition classDefinition, FieldDefinition fieldDefinition) {
        for (AnnotationDefinition annotationDefinition : fieldDefinition.getAnnotations()) {
            this.visitAnnotation(fieldDefinition, annotationDefinition);
        }
        return null;
    }

    public T visitMethod(ClassDefinition classDefinition, MethodDefinition methodDefinition) {
        for (AnnotationDefinition annotationDefinition : methodDefinition.getAnnotations()) {
            this.visitAnnotation(methodDefinition, annotationDefinition);
        }
        methodDefinition.getBody().accept(null, this);
        return null;
    }

    public T visitNode(BytecodeNode parent, BytecodeNode node) {
        for (BytecodeNode child : node.getChildNodes()) {
            child.accept(node, this);
        }
        return null;
    }

    public T visitComment(BytecodeNode parent, Comment node) {
        return this.visitNode(parent, node);
    }

    public T visitBlock(BytecodeNode parent, BytecodeBlock block) {
        return this.visitNode(parent, block);
    }

    public T visitBytecodeExpression(BytecodeNode parent, BytecodeExpression expression) {
        return this.visitNode(parent, expression);
    }

    public T visitFlowControl(BytecodeNode parent, FlowControl flowControl) {
        return this.visitNode(parent, flowControl);
    }

    public T visitTryCatch(BytecodeNode parent, TryCatch tryCatch) {
        return this.visitFlowControl(parent, tryCatch);
    }

    public T visitIf(BytecodeNode parent, IfStatement ifStatement) {
        return this.visitFlowControl(parent, ifStatement);
    }

    public T visitFor(BytecodeNode parent, ForLoop forLoop) {
        return this.visitFlowControl(parent, forLoop);
    }

    public T visitWhile(BytecodeNode parent, WhileLoop whileLoop) {
        return this.visitFlowControl(parent, whileLoop);
    }

    public T visitDoWhile(BytecodeNode parent, DoWhileLoop doWhileLoop) {
        return this.visitFlowControl(parent, doWhileLoop);
    }

    public T visitSwitch(BytecodeNode parent, SwitchStatement switchStatement) {
        return this.visitFlowControl(parent, switchStatement);
    }

    public T visitInstruction(BytecodeNode parent, InstructionNode node) {
        return this.visitNode(parent, node);
    }

    public T visitLabel(BytecodeNode parent, LabelNode labelNode) {
        return this.visitInstruction(parent, labelNode);
    }

    public T visitJumpInstruction(BytecodeNode parent, JumpInstruction jumpInstruction) {
        return this.visitInstruction(parent, jumpInstruction);
    }

    public T visitConstant(BytecodeNode parent, Constant constant) {
        return this.visitInstruction(parent, constant);
    }

    public T visitBoxedBooleanConstant(BytecodeNode parent, Constant.BoxedBooleanConstant boxedBooleanConstant) {
        return this.visitConstant(parent, boxedBooleanConstant);
    }

    public T visitBooleanConstant(BytecodeNode parent, Constant.BooleanConstant booleanConstant) {
        return this.visitConstant(parent, booleanConstant);
    }

    public T visitIntConstant(BytecodeNode parent, Constant.IntConstant intConstant) {
        return this.visitConstant(parent, intConstant);
    }

    public T visitBoxedIntegerConstant(BytecodeNode parent, Constant.BoxedIntegerConstant boxedIntegerConstant) {
        return this.visitConstant(parent, boxedIntegerConstant);
    }

    public T visitFloatConstant(BytecodeNode parent, Constant.FloatConstant floatConstant) {
        return this.visitConstant(parent, floatConstant);
    }

    public T visitBoxedFloatConstant(BytecodeNode parent, Constant.BoxedFloatConstant boxedFloatConstant) {
        return this.visitConstant(parent, boxedFloatConstant);
    }

    public T visitLongConstant(BytecodeNode parent, Constant.LongConstant longConstant) {
        return this.visitConstant(parent, longConstant);
    }

    public T visitBoxedLongConstant(BytecodeNode parent, Constant.BoxedLongConstant boxedLongConstant) {
        return this.visitConstant(parent, boxedLongConstant);
    }

    public T visitDoubleConstant(BytecodeNode parent, Constant.DoubleConstant doubleConstant) {
        return this.visitConstant(parent, doubleConstant);
    }

    public T visitBoxedDoubleConstant(BytecodeNode parent, Constant.BoxedDoubleConstant boxedDoubleConstant) {
        return this.visitConstant(parent, boxedDoubleConstant);
    }

    public T visitStringConstant(BytecodeNode parent, Constant.StringConstant stringConstant) {
        return this.visitConstant(parent, stringConstant);
    }

    public T visitClassConstant(BytecodeNode parent, Constant.ClassConstant classConstant) {
        return this.visitConstant(parent, classConstant);
    }

    public T visitVariableInstruction(BytecodeNode parent, VariableInstruction variableInstruction) {
        return this.visitInstruction(parent, variableInstruction);
    }

    public T visitLoadVariable(BytecodeNode parent, VariableInstruction.LoadVariableInstruction loadVariableInstruction) {
        return this.visitVariableInstruction(parent, loadVariableInstruction);
    }

    public T visitStoreVariable(BytecodeNode parent, VariableInstruction.StoreVariableInstruction storeVariableInstruction) {
        return this.visitVariableInstruction(parent, storeVariableInstruction);
    }

    public T visitIncrementVariable(BytecodeNode parent, VariableInstruction.IncrementVariableInstruction incrementVariableInstruction) {
        return this.visitVariableInstruction(parent, incrementVariableInstruction);
    }

    public T visitFieldInstruction(BytecodeNode parent, FieldInstruction fieldInstruction) {
        return this.visitInstruction(parent, fieldInstruction);
    }

    public T visitGetField(BytecodeNode parent, FieldInstruction.GetFieldInstruction getFieldInstruction) {
        return this.visitFieldInstruction(parent, getFieldInstruction);
    }

    public T visitPutField(BytecodeNode parent, FieldInstruction.PutFieldInstruction putFieldInstruction) {
        return this.visitFieldInstruction(parent, putFieldInstruction);
    }

    public T visitInvoke(BytecodeNode parent, InvokeInstruction invokeInstruction) {
        return this.visitInstruction(parent, invokeInstruction);
    }

    public T visitInvokeDynamic(BytecodeNode parent, InvokeInstruction.InvokeDynamicInstruction invokeDynamicInstruction) {
        return this.visitInvoke(parent, invokeDynamicInstruction);
    }

    public T visitDebug(BytecodeNode parent, DebugNode debugNode) {
        return this.visitNode(parent, debugNode);
    }

    public T visitLineNumber(BytecodeNode parent, LineNumberNode lineNumberNode) {
        return this.visitDebug(parent, lineNumberNode);
    }

    public T visitLocalVariable(BytecodeNode parent, LocalVariableNode localVariableNode) {
        return this.visitDebug(parent, localVariableNode);
    }
}

