/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rest.exception.handler.replacement;

import io.micronaut.context.annotation.Replaces;
import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.server.exceptions.ExceptionHandler;
import io.micronaut.security.authentication.AuthenticationException;
import io.micronaut.security.authentication.AuthenticationExceptionHandler;
import jakarta.inject.Singleton;
import org.apache.ignite.internal.rest.api.Problem;
import org.apache.ignite.internal.rest.constants.HttpCode;
import org.apache.ignite.internal.rest.problem.HttpProblemResponse;

@Singleton
@Replaces(value=AuthenticationExceptionHandler.class)
@Requires(classes={AuthenticationException.class, ExceptionHandler.class})
public class AuthenticationExceptionHandlerReplacement
implements ExceptionHandler<AuthenticationException, HttpResponse<? extends Problem>> {
    public HttpResponse<? extends Problem> handle(HttpRequest request, AuthenticationException exception) {
        return HttpProblemResponse.from(Problem.fromHttpCode(HttpCode.UNAUTHORIZED).detail(exception.getMessage()));
    }
}

