/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.communication.tcp.internal;

import java.util.Map;
import java.util.UUID;
import org.apache.ignite.spi.IgniteSpiAdapter;
import org.apache.ignite.spi.IgniteSpiMBeanAdapter;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationMetricsListener;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationSpiMBean;
import org.apache.ignite.spi.communication.tcp.internal.ClusterStateProvider;
import org.apache.ignite.spi.communication.tcp.internal.TcpCommunicationConfiguration;

public class TcpCommunicationSpiMBeanImpl
extends IgniteSpiMBeanAdapter
implements TcpCommunicationSpiMBean {
    private final TcpCommunicationMetricsListener metricsLsnr;
    private final TcpCommunicationConfiguration cfg;
    private final ClusterStateProvider stateProvider;

    public TcpCommunicationSpiMBeanImpl(IgniteSpiAdapter spiAdapter, TcpCommunicationMetricsListener metricsLsnr, TcpCommunicationConfiguration cfg, ClusterStateProvider stateProvider) {
        super(spiAdapter);
        this.metricsLsnr = metricsLsnr;
        this.cfg = cfg;
        this.stateProvider = stateProvider;
    }

    @Override
    public String getLocalAddress() {
        return this.cfg.localAddress();
    }

    @Override
    public int getLocalPort() {
        return this.cfg.localPort();
    }

    @Override
    public int getLocalPortRange() {
        return this.cfg.localPortRange();
    }

    @Override
    public boolean isUsePairedConnections() {
        return this.cfg.usePairedConnections();
    }

    @Override
    public int getConnectionsPerNode() {
        return this.cfg.connectionsPerNode();
    }

    @Override
    public int getSharedMemoryPort() {
        return -1;
    }

    @Override
    public long getIdleConnectionTimeout() {
        return this.cfg.idleConnectionTimeout();
    }

    @Override
    public long getSocketWriteTimeout() {
        return this.cfg.socketWriteTimeout();
    }

    @Override
    public int getAckSendThreshold() {
        return this.cfg.ackSendThreshold();
    }

    @Override
    public int getUnacknowledgedMessagesBufferSize() {
        return this.cfg.unackedMsgsBufferSize();
    }

    @Override
    public long getConnectTimeout() {
        return this.cfg.connectionTimeout();
    }

    @Override
    public long getMaxConnectTimeout() {
        return this.cfg.maxConnectionTimeout();
    }

    @Override
    public int getReconnectCount() {
        return this.cfg.reconCount();
    }

    @Override
    public boolean isDirectBuffer() {
        return this.cfg.directBuffer();
    }

    @Override
    public boolean isDirectSendBuffer() {
        return this.cfg.directSendBuffer();
    }

    @Override
    public int getSelectorsCount() {
        return this.cfg.selectorsCount();
    }

    @Override
    public long getSelectorSpins() {
        return this.cfg.selectorSpins();
    }

    @Override
    public boolean isTcpNoDelay() {
        return this.cfg.tcpNoDelay();
    }

    @Override
    public int getSocketReceiveBuffer() {
        return this.cfg.socketReceiveBuffer();
    }

    @Override
    public int getSocketSendBuffer() {
        return this.cfg.socketSendBuffer();
    }

    @Override
    public int getMessageQueueLimit() {
        return this.cfg.messageQueueLimit();
    }

    @Override
    public int getSlowClientQueueLimit() {
        return this.cfg.slowClientQueueLimit();
    }

    @Override
    public void dumpStats() {
        this.stateProvider.dumpStats();
    }

    @Override
    public int getSentMessagesCount() {
        return this.metricsLsnr.sentMessagesCount();
    }

    @Override
    public long getSentBytesCount() {
        return this.metricsLsnr.sentBytesCount();
    }

    @Override
    public int getReceivedMessagesCount() {
        return this.metricsLsnr.receivedMessagesCount();
    }

    @Override
    public long getReceivedBytesCount() {
        return this.metricsLsnr.receivedBytesCount();
    }

    @Override
    public Map<String, Long> getReceivedMessagesByType() {
        return this.metricsLsnr.receivedMessagesByType();
    }

    @Override
    public Map<UUID, Long> getReceivedMessagesByNode() {
        return this.metricsLsnr.receivedMessagesByNode();
    }

    @Override
    public Map<String, Long> getSentMessagesByType() {
        return this.metricsLsnr.sentMessagesByType();
    }

    @Override
    public Map<UUID, Long> getSentMessagesByNode() {
        return this.metricsLsnr.sentMessagesByNode();
    }

    @Override
    public int getOutboundMessagesQueueSize() {
        return this.stateProvider.getOutboundMessagesQueueSize();
    }
}

