/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.thread.IgniteThread;

public abstract class IgniteSpiThread
extends IgniteThread {
    private static final AtomicLong cntr = new AtomicLong();
    private final IgniteLogger log;

    protected IgniteSpiThread(String igniteInstanceName, String name, IgniteLogger log) {
        super(igniteInstanceName, IgniteSpiThread.createName(cntr.incrementAndGet(), name, igniteInstanceName));
        assert (log != null);
        this.log = log;
    }

    @Override
    public final void run() {
        try {
            this.body();
        }
        catch (InterruptedException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Caught interrupted exception: " + e);
            }
            Thread.currentThread().interrupt();
        }
        catch (Throwable e) {
            U.error(this.log, "Runtime error caught during grid runnable execution: " + this, e);
            if (e instanceof Error) {
                throw e;
            }
        }
        finally {
            this.cleanup();
            if (this.log.isDebugEnabled()) {
                if (this.isInterrupted()) {
                    this.log.debug("Grid runnable finished due to interruption without cancellation: " + this.getName());
                } else {
                    this.log.debug("Grid runnable finished normally: " + this.getName());
                }
            }
        }
    }

    protected void cleanup() {
    }

    protected abstract void body() throws InterruptedException;

    @Override
    public String toString() {
        return S.toString(IgniteSpiThread.class, this, "name", (Object)this.getName());
    }
}

