/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.service;

import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServiceDeploymentProcessId
implements Message {
    private static final long serialVersionUID = 0L;
    @Nullable
    private AffinityTopologyVersion topVer;
    @Nullable
    private IgniteUuid reqId;

    public ServiceDeploymentProcessId() {
    }

    ServiceDeploymentProcessId(@NotNull AffinityTopologyVersion topVer) {
        this.topVer = topVer;
    }

    ServiceDeploymentProcessId(@NotNull IgniteUuid reqId) {
        this.reqId = reqId;
    }

    public AffinityTopologyVersion topologyVersion() {
        return this.topVer;
    }

    public IgniteUuid requestId() {
        return this.reqId;
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeMessage("topVer", this.topVer)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeIgniteUuid("reqId", this.reqId)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.topVer = (AffinityTopologyVersion)reader.readMessage("topVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.reqId = reader.readIgniteUuid("reqId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(ServiceDeploymentProcessId.class);
    }

    @Override
    public short directType() {
        return 167;
    }

    @Override
    public byte fieldsCount() {
        return 2;
    }

    @Override
    public void onAckReceived() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceDeploymentProcessId id = (ServiceDeploymentProcessId)o;
        return F.eq(this.topVer, id.topVer) && F.eq(this.reqId, id.reqId);
    }

    public int hashCode() {
        return Objects.hash(this.topVer, this.reqId);
    }

    public String toString() {
        return S.toString(ServiceDeploymentProcessId.class, this);
    }
}

