/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.schema;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.internal.processors.query.QueryTypeDescriptorImpl;
import org.apache.ignite.internal.util.typedef.internal.A;

public class SchemaIndexCacheStat {
    private final Map<String, QueryTypeDescriptorImpl> types = new HashMap<String, QueryTypeDescriptorImpl>();
    private int scanned;

    public void accumulate(SchemaIndexCacheStat stat) {
        this.scanned += stat.scanned;
        this.types.putAll(stat.types);
    }

    public void addType(QueryTypeDescriptorImpl type) {
        this.types.put(type.name(), type);
    }

    public void add(int scanned) {
        A.ensure(scanned >= 0, "scanned is negative. Value: " + scanned);
        this.scanned += scanned;
    }

    public int scannedKeys() {
        return this.scanned;
    }

    public Collection<String> typeNames() {
        return Collections.unmodifiableCollection(this.types.keySet());
    }

    public Collection<QueryTypeDescriptorImpl> types() {
        return Collections.unmodifiableCollection(this.types.values());
    }
}

