/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.wal.io;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIO;
import org.apache.ignite.internal.processors.cache.persistence.wal.ByteBufferExpander;
import org.apache.ignite.internal.processors.cache.persistence.wal.io.FileInput;
import org.jetbrains.annotations.NotNull;

public class SimpleFileInput
implements FileInput {
    private ByteBuffer buf;
    protected FileIO io;
    private long pos;
    private ByteBufferExpander expBuf;

    public SimpleFileInput(FileIO io, ByteBufferExpander buf) throws IOException {
        assert (io != null);
        this.io = io;
        this.buf = buf.buffer();
        this.expBuf = buf;
        this.pos = io.position();
        this.clearBuffer();
    }

    @Override
    public FileIO io() {
        return this.io;
    }

    private void clearBuffer() {
        this.buf.clear();
        this.buf.limit(0);
        assert (this.buf.remaining() == 0);
    }

    @Override
    public void seek(long pos) throws IOException {
        if (pos > this.io.size()) {
            throw new EOFException();
        }
        this.io.position(pos);
        this.pos = pos;
        this.clearBuffer();
    }

    @Override
    public ByteBuffer buffer() {
        return this.buf;
    }

    @Override
    public void ensure(int requested) throws IOException {
        int read;
        int available = this.buf.remaining();
        if (available >= requested) {
            return;
        }
        if (this.buf.capacity() < requested) {
            if (this.expBuf == null) {
                throw new IOException("Requested size is greater than buffer: " + requested);
            }
            this.buf = this.expBuf.expand(requested);
            assert (available == this.buf.remaining());
        }
        this.buf.compact();
        do {
            if ((read = this.io.read(this.buf)) == -1) {
                throw new EOFException("EOF at position [" + this.io.position() + "] expected to read [" + requested + "] bytes");
            }
            this.pos += (long)read;
        } while ((available += read) < requested);
        this.buf.flip();
    }

    @Override
    public long position() {
        return this.pos - (long)this.buf.remaining();
    }

    @Override
    public void readFully(@NotNull byte[] b) throws IOException {
        this.ensure(b.length);
        this.buf.get(b);
    }

    @Override
    public void readFully(@NotNull byte[] b, int off, int len) throws IOException {
        this.ensure(len);
        this.buf.get(b, off, len);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        if (this.buf.remaining() >= n) {
            this.buf.position(this.buf.position() + n);
        } else {
            this.seek(this.pos + (long)n);
        }
        return n;
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.readByte() == 1;
    }

    @Override
    public byte readByte() throws IOException {
        this.ensure(1);
        return this.buf.get();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.readByte() & 0xFF;
    }

    @Override
    public short readShort() throws IOException {
        this.ensure(2);
        return this.buf.getShort();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.readShort() & 0xFFFF;
    }

    @Override
    public char readChar() throws IOException {
        this.ensure(2);
        return this.buf.getChar();
    }

    @Override
    public int readInt() throws IOException {
        this.ensure(4);
        return this.buf.getInt();
    }

    @Override
    public long readLong() throws IOException {
        this.ensure(8);
        return this.buf.getLong();
    }

    @Override
    public float readFloat() throws IOException {
        this.ensure(4);
        return this.buf.getFloat();
    }

    @Override
    public double readDouble() throws IOException {
        this.ensure(8);
        return this.buf.getDouble();
    }

    @Override
    public String readLine() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String readUTF() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public FileInput.Crc32CheckingFileInput startRead(boolean skipCheck) {
        return new FileInput.Crc32CheckingFileInput(this, skipCheck);
    }
}

