/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.cache.Cache;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheIterator;
import org.apache.ignite.internal.util.F0;
import org.apache.ignite.internal.util.GridSerializableCollection;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.lang.IgnitePredicate;
import org.jetbrains.annotations.Nullable;

public class GridCacheValueCollection<K, V>
extends GridSerializableCollection<V> {
    private static final long serialVersionUID = 0L;
    private final GridCacheContext<K, V> ctx;
    private final IgnitePredicate<Cache.Entry<K, V>>[] filter;
    private final Map<K, Cache.Entry<K, V>> map;

    public GridCacheValueCollection(GridCacheContext<K, V> ctx, Collection<? extends Cache.Entry<K, V>> c, @Nullable IgnitePredicate<Cache.Entry<K, V>>[] filter) {
        this.map = new HashMap<K, Cache.Entry<K, V>>(c.size(), 1.0f);
        assert (ctx != null);
        this.ctx = ctx;
        this.filter = filter;
        for (Cache.Entry<K, V> e : c) {
            if (e == null) continue;
            this.map.put(e.getKey(), e);
        }
    }

    @Override
    public Iterator<V> iterator() {
        return new GridCacheIterator<K, V, V>(this.ctx, this.map.values(), F.cacheEntry2Get(), this.ctx.vararg(F0.and(this.filter, F.cacheHasPeekValue()))){
            private V next;
            {
                this.advance();
            }

            private void advance() {
                boolean has;
                if (this.next != null) {
                    return;
                }
                while (has = super.hasNext()) {
                    this.next = super.next();
                    if (this.next == null) continue;
                }
                if (!has) {
                    this.next = null;
                }
            }

            @Override
            public boolean hasNext() {
                this.advance();
                return this.next != null;
            }

            @Override
            public V next() {
                this.advance();
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                Object v = this.next;
                this.next = null;
                return v;
            }
        };
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        A.notNull(o, "o");
        boolean rmv = false;
        Iterator<Cache.Entry<K, V>> it = this.map.values().iterator();
        while (it.hasNext()) {
            Cache.Entry<K, V> e = it.next();
            if (!F.isAll(e, this.filter) || !F.eq(o, e.getValue())) continue;
            it.remove();
            this.ctx.grid().cache(this.ctx.name()).remove(e.getKey(), e.getValue());
            rmv = true;
        }
        return rmv;
    }

    @Override
    public int size() {
        return F.size(this.map.values(), this.filter);
    }

    @Override
    public boolean contains(Object o) {
        A.notNull(o, "o");
        for (Cache.Entry<K, V> e : this.map.values()) {
            if (!F.isAll(e, this.filter) || !F.eq(e.getValue(), o)) continue;
            return true;
        }
        return false;
    }
}

