/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.events.CacheEvent;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.internal.managers.discovery.DiscoCache;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsExchangeFuture;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;

public class ExchangeDiscoveryEvents {
    private AffinityTopologyVersion topVer;
    private AffinityTopologyVersion srvEvtTopVer;
    private DiscoCache discoCache;
    private DiscoveryEvent lastEvt;
    private DiscoveryEvent lastSrvEvt;
    private Collection<DiscoveryEvent> evts = new ConcurrentLinkedQueue<DiscoveryEvent>();
    private Collection<ClusterNode> joinedSrvNodes = new ConcurrentLinkedQueue<ClusterNode>();
    private Collection<ClusterNode> leftSrvNodes = new ConcurrentLinkedQueue<ClusterNode>();

    ExchangeDiscoveryEvents(GridDhtPartitionsExchangeFuture fut) {
        this.addEvent(fut.initialVersion(), fut.firstEvent(), fut.firstEventCache());
    }

    public void processEvents(GridDhtPartitionsExchangeFuture fut) {
        if (this.hasServerLeft()) {
            this.warnNoAffinityNodes(fut.sharedContext());
        }
    }

    public boolean nodeJoined(UUID nodeId) {
        for (DiscoveryEvent evt : this.evts) {
            if (evt.type() != 10 || !nodeId.equals(evt.eventNode().id())) continue;
            return true;
        }
        return false;
    }

    AffinityTopologyVersion lastServerEventVersion() {
        assert (this.srvEvtTopVer != null) : this;
        return this.srvEvtTopVer;
    }

    void addEvent(AffinityTopologyVersion topVer, DiscoveryEvent evt, DiscoCache cache) {
        assert (this.evts.isEmpty() || topVer.compareTo(this.topVer) > 0) : topVer;
        this.evts.add(evt);
        this.topVer = topVer;
        this.lastEvt = evt;
        this.discoCache = cache;
        ClusterNode node = evt.eventNode();
        if (!node.isClient()) {
            this.lastSrvEvt = evt;
            this.srvEvtTopVer = new AffinityTopologyVersion(evt.topologyVersion(), 0);
            if (evt.type() == 10) {
                this.joinedSrvNodes.add(evt.eventNode());
            } else if (evt.type() == 11 || evt.type() == 12) {
                this.leftSrvNodes.add(evt.eventNode());
            }
        }
    }

    public Collection<DiscoveryEvent> events() {
        return this.evts;
    }

    public static boolean serverLeftEvent(DiscoveryEvent evt) {
        return (evt.type() == 12 || evt.type() == 11) && !evt.eventNode().isClient();
    }

    public static boolean serverJoinEvent(DiscoveryEvent evt) {
        return evt.type() == 10 && !evt.eventNode().isClient();
    }

    public DiscoCache discoveryCache() {
        return this.discoCache;
    }

    public DiscoveryEvent lastEvent() {
        return this.lastSrvEvt != null ? this.lastSrvEvt : this.lastEvt;
    }

    public AffinityTopologyVersion topologyVersion() {
        return this.topVer;
    }

    public boolean hasServerJoin() {
        return !this.joinedSrvNodes.isEmpty();
    }

    public boolean hasServerLeft() {
        return !this.leftSrvNodes.isEmpty();
    }

    public Collection<ClusterNode> joinedServerNodes() {
        return this.joinedSrvNodes;
    }

    public Collection<ClusterNode> leftServerNodes() {
        return this.leftSrvNodes;
    }

    public void warnNoAffinityNodes(GridCacheSharedContext<?, ?> cctx) {
        ArrayList<String> cachesWithoutNodes = null;
        for (DynamicCacheDescriptor cacheDesc : cctx.cache().cacheDescriptors().values()) {
            if (!this.discoCache.cacheGroupAffinityNodes(cacheDesc.groupId()).isEmpty()) continue;
            if (cachesWithoutNodes == null) {
                cachesWithoutNodes = new ArrayList<String>();
            }
            cachesWithoutNodes.add(cacheDesc.cacheName());
            if (!cctx.gridEvents().isRecordable(100)) continue;
            CacheEvent evt = new CacheEvent(cacheDesc.cacheName(), cctx.localNode(), cctx.localNode(), "All server nodes have left the cluster.", 100, 0, false, null, null, null, null, null, false, null, false, null, null, null);
            cctx.gridEvents().record(evt);
        }
        if (cachesWithoutNodes != null) {
            StringBuilder sb = new StringBuilder("All server nodes for the following caches have left the cluster: ");
            for (int i = 0; i < cachesWithoutNodes.size(); ++i) {
                String cache = (String)cachesWithoutNodes.get(i);
                sb.append('\'').append(cache).append('\'');
                if (i == cachesWithoutNodes.size() - 1) continue;
                sb.append(", ");
            }
            IgniteLogger log = cctx.logger(this.getClass());
            U.quietAndWarn(log, sb.toString());
            U.quietAndWarn(log, "Must have server nodes for caches to operate.");
        }
    }

    public String toString() {
        return S.toString(ExchangeDiscoveryEvents.class, this);
    }
}

