/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.managers.systemview.walker;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.spi.systemview.view.PartitionStateView;
import org.apache.ignite.spi.systemview.view.SystemViewRowAttributeWalker;

public class PartitionStateViewWalker
implements SystemViewRowAttributeWalker<PartitionStateView> {
    public static final String CACHE_GROUP_ID_FILTER = "cacheGroupId";
    public static final String NODE_ID_FILTER = "nodeId";
    public static final String PARTITION_ID_FILTER = "partitionId";
    private static final List<String> FILTRABLE_ATTRS = Collections.unmodifiableList(F.asList(new String[]{"cacheGroupId", "nodeId", "partitionId"}));

    @Override
    public List<String> filtrableAttributes() {
        return FILTRABLE_ATTRS;
    }

    @Override
    public void visitAll(SystemViewRowAttributeWalker.AttributeVisitor v) {
        v.accept(0, CACHE_GROUP_ID_FILTER, Integer.TYPE);
        v.accept(1, NODE_ID_FILTER, UUID.class);
        v.accept(2, PARTITION_ID_FILTER, Integer.TYPE);
        v.accept(3, "state", String.class);
        v.accept(4, "isPrimary", Boolean.TYPE);
    }

    @Override
    public void visitAll(PartitionStateView row, SystemViewRowAttributeWalker.AttributeWithValueVisitor v) {
        v.acceptInt(0, CACHE_GROUP_ID_FILTER, row.cacheGroupId());
        v.accept(1, NODE_ID_FILTER, UUID.class, row.nodeId());
        v.acceptInt(2, PARTITION_ID_FILTER, row.partitionId());
        v.accept(3, "state", String.class, row.state());
        v.acceptBoolean(4, "isPrimary", row.isPrimary());
    }

    @Override
    public int count() {
        return 5;
    }
}

