/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index.sorted;

import java.util.LinkedHashMap;
import org.apache.ignite.internal.cache.query.index.IndexName;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyDefinition;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyTypeSettings;
import org.apache.ignite.internal.cache.query.index.sorted.IndexRowCache;
import org.apache.ignite.internal.cache.query.index.sorted.IndexRowComparator;
import org.apache.ignite.internal.cache.query.index.sorted.IndexRowComparatorImpl;
import org.apache.ignite.internal.cache.query.index.sorted.InlineIndexRowHandlerFactory;
import org.apache.ignite.internal.cache.query.index.sorted.QueryIndexRowHandlerFactory;
import org.apache.ignite.internal.cache.query.index.sorted.SortedIndexDefinition;
import org.apache.ignite.internal.processors.cache.GridCacheContextInfo;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;

public class QueryIndexDefinition
implements SortedIndexDefinition {
    private final LinkedHashMap<String, IndexKeyDefinition> keyDefs;
    private final GridQueryTypeDescriptor typeDesc;
    private final GridCacheContextInfo<?, ?> cacheInfo;
    private final IndexName idxName;
    private final String treeName;
    private final int inlineSize;
    private final int segments;
    private final boolean isPrimary;
    private final boolean isAffinity;
    private final IndexRowComparator rowComparator;
    private final IndexKeyTypeSettings keyTypeSettings;
    private final IndexRowCache idxRowCache;
    private final QueryIndexRowHandlerFactory rowHndFactory = new QueryIndexRowHandlerFactory();

    public QueryIndexDefinition(GridQueryTypeDescriptor typeDesc, GridCacheContextInfo<?, ?> cacheInfo, IndexName idxName, String treeName, IndexRowCache idxRowCache, boolean isPrimary, boolean isAffinity, LinkedHashMap<String, IndexKeyDefinition> keyDefs, int cfgInlineSize, IndexKeyTypeSettings keyTypeSettings) {
        this.typeDesc = typeDesc;
        this.cacheInfo = cacheInfo;
        this.idxName = idxName;
        this.treeName = treeName;
        this.idxRowCache = idxRowCache;
        this.segments = cacheInfo.cacheContext().config().getQueryParallelism();
        this.inlineSize = cfgInlineSize;
        this.isPrimary = isPrimary;
        this.isAffinity = isAffinity;
        this.keyDefs = keyDefs;
        this.keyTypeSettings = keyTypeSettings;
        this.rowComparator = new IndexRowComparatorImpl(keyTypeSettings);
    }

    @Override
    public String treeName() {
        return this.treeName;
    }

    @Override
    public LinkedHashMap<String, IndexKeyDefinition> indexKeyDefinitions() {
        return this.keyDefs;
    }

    @Override
    public IndexRowComparator rowComparator() {
        return this.rowComparator;
    }

    @Override
    public int segments() {
        return this.segments;
    }

    @Override
    public int inlineSize() {
        return this.inlineSize;
    }

    @Override
    public boolean primary() {
        return this.isPrimary;
    }

    @Override
    public boolean affinity() {
        return this.isAffinity;
    }

    @Override
    public InlineIndexRowHandlerFactory rowHandlerFactory() {
        return this.rowHndFactory;
    }

    @Override
    public IndexKeyTypeSettings keyTypeSettings() {
        return this.keyTypeSettings;
    }

    @Override
    public IndexRowCache idxRowCache() {
        return this.idxRowCache;
    }

    @Override
    public IndexName idxName() {
        return this.idxName;
    }

    @Override
    public GridQueryTypeDescriptor typeDescriptor() {
        return this.typeDesc;
    }

    @Override
    public GridCacheContextInfo<?, ?> cacheInfo() {
        return this.cacheInfo;
    }

    public String toString() {
        String flds = String.join((CharSequence)", ", this.indexKeyDefinitions().keySet());
        return "QueryIndex[name=" + this.idxName.idxName() + ", fields=" + flds + "]";
    }
}

