/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index;

import org.jetbrains.annotations.Nullable;

public class IndexName {
    @Nullable
    private final String schemaName;
    @Nullable
    private final String tableName;
    private final String cacheName;
    private final String idxName;

    public IndexName(String cacheName, @Nullable String schemaName, @Nullable String tableName, String idxName) {
        this.cacheName = cacheName;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.idxName = idxName;
    }

    public String fullName() {
        StringBuilder bld = new StringBuilder();
        if (this.schemaName != null) {
            bld.append(this.schemaName).append(".");
        }
        if (this.tableName != null) {
            bld.append(this.tableName).append(".");
        }
        return bld.append(this.idxName).toString();
    }

    public String idxName() {
        return this.idxName;
    }

    public String tableName() {
        return this.tableName;
    }

    public String schemaName() {
        return this.schemaName;
    }

    public String cacheName() {
        return this.cacheName;
    }
}

