/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.tostring;

import java.util.Arrays;

public class CircularStringBuilder {
    private final char[] value;
    private int finishAt = -1;
    private boolean full;
    private int skipped = 0;

    CircularStringBuilder(int capacity) {
        assert (capacity > 0) : "Can't allocate CircularStringBuilder with capacity: " + capacity;
        this.value = new char[capacity];
    }

    public void reset() {
        Arrays.fill(this.value, '\u0000');
        this.finishAt = -1;
        this.full = false;
        this.skipped = 0;
    }

    public int length() {
        return this.full ? this.value.length : this.finishAt + 1;
    }

    public int capacity() {
        return this.value.length;
    }

    public CircularStringBuilder append(Object obj) {
        return this.append(String.valueOf(obj));
    }

    public CircularStringBuilder append(String str) {
        if (str == null) {
            return this.appendNull();
        }
        int objStrLen = str.length();
        if (objStrLen >= this.value.length) {
            str.getChars(objStrLen - this.value.length, objStrLen, this.value, 0);
            this.skipped += objStrLen - this.value.length + this.finishAt + 1;
            this.finishAt = this.value.length - 1;
            this.full = true;
        } else if (this.value.length - this.finishAt - 1 < objStrLen) {
            int firstPart = this.value.length - this.finishAt - 1;
            if (firstPart > 0) {
                str.getChars(0, firstPart, this.value, this.finishAt + 1);
            }
            str.getChars(firstPart, objStrLen, this.value, 0);
            this.skipped += this.full ? objStrLen : objStrLen - firstPart;
            this.finishAt = this.finishAt + objStrLen - this.value.length;
            this.full = true;
        } else {
            str.getChars(0, objStrLen, this.value, this.finishAt + 1);
            this.skipped += this.full ? objStrLen : 0;
            this.finishAt += objStrLen;
        }
        return this;
    }

    public CircularStringBuilder append(StringBuffer sb) {
        if (sb == null) {
            return this.appendNull();
        }
        int len = sb.length();
        if (len < this.value.length) {
            this.append(sb.toString());
        } else {
            this.skipped += len - this.value.length;
            this.append(sb.substring(len - this.value.length));
        }
        return this;
    }

    private CircularStringBuilder appendNull() {
        this.append("null");
        return this;
    }

    public int getSkipped() {
        return this.skipped;
    }

    public String toString() {
        if (this.full) {
            char[] strVal = new char[this.value.length];
            int firstPart = this.value.length - this.finishAt - 1;
            System.arraycopy(this.value, this.finishAt + 1, strVal, 0, firstPart);
            System.arraycopy(this.value, 0, strVal, firstPart, this.value.length - firstPart);
            return new String(strVal, 0, strVal.length);
        }
        return new String(this.value, 0, this.finishAt + 1);
    }
}

