/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.lang;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;
import org.jetbrains.annotations.Nullable;

public class GridNodePredicate
implements IgnitePredicate<ClusterNode>,
Iterable<UUID> {
    private static final long serialVersionUID = 0L;
    @GridToStringInclude
    private final Set<UUID> ids;
    @GridToStringExclude
    private int hash = Integer.MIN_VALUE;

    public GridNodePredicate(Set<UUID> ids) {
        assert (ids != null);
        this.ids = ids;
    }

    public GridNodePredicate(@Nullable Collection<UUID> ids) {
        this.ids = F.isEmpty(ids) ? Collections.emptySet() : (ids.size() == 1 ? Collections.singleton(F.first(ids)) : new HashSet<UUID>(ids));
    }

    public GridNodePredicate(UUID ... ids) {
        if (F.isEmpty(ids)) {
            this.ids = Collections.emptySet();
        } else if (ids.length == 1) {
            this.ids = Collections.singleton(ids[0]);
        } else {
            this.ids = U.newHashSet(ids.length);
            Collections.addAll(this.ids, ids);
        }
    }

    public GridNodePredicate(ClusterNode ... nodes) {
        if (F.isEmpty(nodes)) {
            this.ids = Collections.emptySet();
        } else if (nodes.length == 1) {
            ClusterNode node = nodes[0];
            this.ids = node != null ? Collections.singleton(node.id()) : Collections.emptySet();
        } else {
            this.ids = U.newHashSet(nodes.length);
            for (ClusterNode n : nodes) {
                if (n == null) continue;
                this.ids.add(n.id());
            }
        }
    }

    public Set<UUID> nodeIds() {
        return this.ids;
    }

    @Override
    public Iterator<UUID> iterator() {
        return this.ids.iterator();
    }

    @Override
    public boolean apply(ClusterNode n) {
        assert (n != null);
        return this.ids.contains(n.id());
    }

    public int hashCode() {
        if (this.hash == Integer.MIN_VALUE) {
            this.hash = this.ids.hashCode();
        }
        return this.hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GridNodePredicate)) {
            return false;
        }
        GridNodePredicate it = (GridNodePredicate)o;
        return this.ids.equals(it.ids);
    }

    public String toString() {
        return S.toString(GridNodePredicate.class, this);
    }
}

