/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.internal.util.GridBoundedConcurrentLinkedHashMap;
import org.apache.ignite.internal.util.GridSetWrapper;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;
import org.jsr166.ConcurrentLinkedHashMap;

public class GridBoundedConcurrentLinkedHashSet<E>
extends GridSetWrapper<E> {
    private static final long serialVersionUID = 0L;

    public GridBoundedConcurrentLinkedHashSet(int max) {
        this(max, 16, 0.75f, 16);
    }

    public GridBoundedConcurrentLinkedHashSet(int max, int initCap) {
        this(max, initCap, 0.75f, 16);
    }

    public GridBoundedConcurrentLinkedHashSet(int max, int initCap, float loadFactor) {
        this(max, initCap, loadFactor, 16);
    }

    public GridBoundedConcurrentLinkedHashSet(int max, int initCap, float loadFactor, int concurLvl) {
        this(max, initCap, loadFactor, concurLvl, ConcurrentLinkedHashMap.QueuePolicy.SINGLE_Q);
    }

    public GridBoundedConcurrentLinkedHashSet(int max, int initCap, float loadFactor, int concurLvl, ConcurrentLinkedHashMap.QueuePolicy qPlc) {
        super(new GridBoundedConcurrentLinkedHashMap(max, initCap, loadFactor, concurLvl, qPlc));
    }

    @Override
    public boolean add(E e) {
        ConcurrentMap m = (ConcurrentMap)this.map;
        return m.putIfAbsent(e, e) == null;
    }

    @Nullable
    public E addx(E e) {
        ConcurrentMap map0 = (ConcurrentMap)this.map();
        return map0.putIfAbsent(e, e);
    }

    public int sizex() {
        return ((ConcurrentLinkedHashMap)this.map()).sizex();
    }

    @Override
    public String toString() {
        return S.toString(GridBoundedConcurrentLinkedHashSet.class, this, "elements", this.map().keySet());
    }
}

