/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest.client.message;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class GridClientNodeMetricsBean
implements Externalizable {
    private static final long serialVersionUID = 0L;
    private long lastUpdateTime = -1L;
    private int maxActiveJobs = -1;
    private int curActiveJobs = -1;
    private float avgActiveJobs = -1.0f;
    private int maxWaitingJobs = -1;
    private int curWaitingJobs = -1;
    private float avgWaitingJobs = -1.0f;
    private int maxRejectedJobs = -1;
    private int curRejectedJobs = -1;
    private float avgRejectedJobs = -1.0f;
    private int maxCancelledJobs = -1;
    private int curCancelledJobs = -1;
    private float avgCancelledJobs = -1.0f;
    private int totalRejectedJobs = -1;
    private int totalCancelledJobs = -1;
    private int totalExecutedJobs = -1;
    private long maxJobWaitTime = -1L;
    private long curJobWaitTime = -1L;
    private double avgJobWaitTime = -1.0;
    private long maxJobExecTime = -1L;
    private long curJobExecTime = -1L;
    private double avgJobExecTime = -1.0;
    private int totalExecTasks = -1;
    private long totalIdleTime = -1L;
    private long curIdleTime = -1L;
    private int availProcs = -1;
    private double load = -1.0;
    private double avgLoad = -1.0;
    private double gcLoad = -1.0;
    private long heapInit = -1L;
    private long heapUsed = -1L;
    private long heapCommitted = -1L;
    private long heapMax = -1L;
    private long nonHeapInit = -1L;
    private long nonHeapUsed = -1L;
    private long nonHeapCommitted = -1L;
    private long nonHeapMax = -1L;
    private long upTime = -1L;
    private long startTime = -1L;
    private long nodeStartTime = -1L;
    private int threadCnt = -1;
    private int peakThreadCnt = -1;
    private long startedThreadCnt = -1L;
    private int daemonThreadCnt = -1;
    private long fileSysFreeSpace = -1L;
    private long fileSysTotalSpace = -1L;
    private long fileSysUsableSpace = -1L;
    private long lastDataVer = -1L;
    private int sentMsgsCnt = -1;
    private long sentBytesCnt = -1L;
    private int rcvdMsgsCnt = -1;
    private long rcvdBytesCnt = -1L;

    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(long lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public int getMaximumActiveJobs() {
        return this.maxActiveJobs;
    }

    public void setMaximumActiveJobs(int maxActiveJobs) {
        this.maxActiveJobs = maxActiveJobs;
    }

    public int getCurrentActiveJobs() {
        return this.curActiveJobs;
    }

    public void setCurrentActiveJobs(int curActiveJobs) {
        this.curActiveJobs = curActiveJobs;
    }

    public float getAverageActiveJobs() {
        return this.avgActiveJobs;
    }

    public void setAverageActiveJobs(float avgActiveJobs) {
        this.avgActiveJobs = avgActiveJobs;
    }

    public int getMaximumWaitingJobs() {
        return this.maxWaitingJobs;
    }

    public void setMaximumWaitingJobs(int maxWaitingJobs) {
        this.maxWaitingJobs = maxWaitingJobs;
    }

    public int getCurrentWaitingJobs() {
        return this.curWaitingJobs;
    }

    public void setCurrentWaitingJobs(int curWaitingJobs) {
        this.curWaitingJobs = curWaitingJobs;
    }

    public float getAverageWaitingJobs() {
        return this.avgWaitingJobs;
    }

    public void setAverageWaitingJobs(float avgWaitingJobs) {
        this.avgWaitingJobs = avgWaitingJobs;
    }

    public int getMaximumRejectedJobs() {
        return this.maxRejectedJobs;
    }

    public void setMaximumRejectedJobs(int maxRejectedJobs) {
        this.maxRejectedJobs = maxRejectedJobs;
    }

    public int getCurrentRejectedJobs() {
        return this.curRejectedJobs;
    }

    public void setCurrentRejectedJobs(int curRejectedJobs) {
        this.curRejectedJobs = curRejectedJobs;
    }

    public float getAverageRejectedJobs() {
        return this.avgRejectedJobs;
    }

    public void setAverageRejectedJobs(float avgRejectedJobs) {
        this.avgRejectedJobs = avgRejectedJobs;
    }

    public int getTotalRejectedJobs() {
        return this.totalRejectedJobs;
    }

    public void setTotalRejectedJobs(int totalRejectedJobs) {
        this.totalRejectedJobs = totalRejectedJobs;
    }

    public int getMaximumCancelledJobs() {
        return this.maxCancelledJobs;
    }

    public void setMaximumCancelledJobs(int maxCancelledJobs) {
        this.maxCancelledJobs = maxCancelledJobs;
    }

    public int getCurrentCancelledJobs() {
        return this.curCancelledJobs;
    }

    public void setCurrentCancelledJobs(int curCancelledJobs) {
        this.curCancelledJobs = curCancelledJobs;
    }

    public float getAverageCancelledJobs() {
        return this.avgCancelledJobs;
    }

    public void setAverageCancelledJobs(float avgCancelledJobs) {
        this.avgCancelledJobs = avgCancelledJobs;
    }

    public int getTotalExecutedJobs() {
        return this.totalExecutedJobs;
    }

    public void setTotalExecutedJobs(int totalExecutedJobs) {
        this.totalExecutedJobs = totalExecutedJobs;
    }

    public int getTotalCancelledJobs() {
        return this.totalCancelledJobs;
    }

    public void setTotalCancelledJobs(int totalCancelledJobs) {
        this.totalCancelledJobs = totalCancelledJobs;
    }

    public long getMaximumJobWaitTime() {
        return this.maxJobWaitTime;
    }

    public void setMaximumJobWaitTime(long maxJobWaitTime) {
        this.maxJobWaitTime = maxJobWaitTime;
    }

    public long getCurrentJobWaitTime() {
        return this.curJobWaitTime;
    }

    public void setCurrentJobWaitTime(long curJobWaitTime) {
        this.curJobWaitTime = curJobWaitTime;
    }

    public double getAverageJobWaitTime() {
        return this.avgJobWaitTime;
    }

    public void setAverageJobWaitTime(double avgJobWaitTime) {
        this.avgJobWaitTime = avgJobWaitTime;
    }

    public long getMaximumJobExecuteTime() {
        return this.maxJobExecTime;
    }

    public void setMaximumJobExecuteTime(long maxJobExecTime) {
        this.maxJobExecTime = maxJobExecTime;
    }

    public long getCurrentJobExecuteTime() {
        return this.curJobExecTime;
    }

    public void setCurrentJobExecuteTime(long curJobExecTime) {
        this.curJobExecTime = curJobExecTime;
    }

    public double getAverageJobExecuteTime() {
        return this.avgJobExecTime;
    }

    public void setAverageJobExecuteTime(double avgJobExecTime) {
        this.avgJobExecTime = avgJobExecTime;
    }

    public int getTotalExecutedTasks() {
        return this.totalExecTasks;
    }

    public void setTotalExecutedTasks(int totalExecTasks) {
        this.totalExecTasks = totalExecTasks;
    }

    public long getTotalBusyTime() {
        return this.getUpTime() - this.getTotalIdleTime();
    }

    public long getTotalIdleTime() {
        return this.totalIdleTime;
    }

    public void setTotalIdleTime(long totalIdleTime) {
        this.totalIdleTime = totalIdleTime;
    }

    public long getCurrentIdleTime() {
        return this.curIdleTime;
    }

    public void setCurrentIdleTime(long curIdleTime) {
        this.curIdleTime = curIdleTime;
    }

    public float getBusyTimePercentage() {
        return 1.0f - this.getIdleTimePercentage();
    }

    public float getIdleTimePercentage() {
        return (float)this.getTotalIdleTime() / (float)this.getUpTime();
    }

    public int getTotalCpus() {
        return this.availProcs;
    }

    public double getCurrentCpuLoad() {
        return this.load;
    }

    public double getAverageCpuLoad() {
        return this.avgLoad;
    }

    public double getCurrentGcCpuLoad() {
        return this.gcLoad;
    }

    public long getHeapMemoryInitialized() {
        return this.heapInit;
    }

    public long getHeapMemoryUsed() {
        return this.heapUsed;
    }

    public long getHeapMemoryCommitted() {
        return this.heapCommitted;
    }

    public long getHeapMemoryMaximum() {
        return this.heapMax;
    }

    public long getNonHeapMemoryInitialized() {
        return this.nonHeapInit;
    }

    public long getNonHeapMemoryUsed() {
        return this.nonHeapUsed;
    }

    public long getNonHeapMemoryCommitted() {
        return this.nonHeapCommitted;
    }

    public long getNonHeapMemoryMaximum() {
        return this.nonHeapMax;
    }

    public long getUpTime() {
        return this.upTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getNodeStartTime() {
        return this.nodeStartTime;
    }

    public int getCurrentThreadCount() {
        return this.threadCnt;
    }

    public int getMaximumThreadCount() {
        return this.peakThreadCnt;
    }

    public long getTotalStartedThreadCount() {
        return this.startedThreadCnt;
    }

    public int getCurrentDaemonThreadCount() {
        return this.daemonThreadCnt;
    }

    public long getFileSystemFreeSpace() {
        return this.fileSysFreeSpace;
    }

    public long getFileSystemTotalSpace() {
        return this.fileSysTotalSpace;
    }

    public long getFileSystemUsableSpace() {
        return this.fileSysUsableSpace;
    }

    public long getLastDataVersion() {
        return this.lastDataVer;
    }

    public void setTotalCpus(int availProcs) {
        this.availProcs = availProcs;
    }

    public void setCurrentCpuLoad(double load) {
        this.load = load;
    }

    public void setAverageCpuLoad(double avgLoad) {
        this.avgLoad = avgLoad;
    }

    public void setCurrentGcCpuLoad(double gcLoad) {
        this.gcLoad = gcLoad;
    }

    public void setHeapMemoryInitialized(long heapInit) {
        this.heapInit = heapInit;
    }

    public void setHeapMemoryUsed(long heapUsed) {
        this.heapUsed = heapUsed;
    }

    public void setHeapMemoryCommitted(long heapCommitted) {
        this.heapCommitted = heapCommitted;
    }

    public void setHeapMemoryMaximum(long heapMax) {
        this.heapMax = heapMax;
    }

    public void setNonHeapMemoryInitialized(long nonHeapInit) {
        this.nonHeapInit = nonHeapInit;
    }

    public void setNonHeapMemoryUsed(long nonHeapUsed) {
        this.nonHeapUsed = nonHeapUsed;
    }

    public void setNonHeapMemoryCommitted(long nonHeapCommitted) {
        this.nonHeapCommitted = nonHeapCommitted;
    }

    public void setNonHeapMemoryMaximum(long nonHeapMax) {
        this.nonHeapMax = nonHeapMax;
    }

    public void setUpTime(long upTime) {
        this.upTime = upTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public void setNodeStartTime(long nodeStartTime) {
        this.nodeStartTime = nodeStartTime;
    }

    public void setCurrentThreadCount(int threadCnt) {
        this.threadCnt = threadCnt;
    }

    public void setMaximumThreadCount(int peakThreadCnt) {
        this.peakThreadCnt = peakThreadCnt;
    }

    public void setTotalStartedThreadCount(long startedThreadCnt) {
        this.startedThreadCnt = startedThreadCnt;
    }

    public void setCurrentDaemonThreadCount(int daemonThreadCnt) {
        this.daemonThreadCnt = daemonThreadCnt;
    }

    public void setFileSystemFreeSpace(long fileSysFreeSpace) {
        this.fileSysFreeSpace = fileSysFreeSpace;
    }

    public void setFileSystemTotalSpace(long fileSysTotalSpace) {
        this.fileSysTotalSpace = fileSysTotalSpace;
    }

    public void setFileSystemUsableSpace(long fileSysUsableSpace) {
        this.fileSysUsableSpace = fileSysUsableSpace;
    }

    public void setLastDataVersion(long lastDataVer) {
        this.lastDataVer = lastDataVer;
    }

    public int getSentMessagesCount() {
        return this.sentMsgsCnt;
    }

    public void setSentMessagesCount(int sentMsgsCnt) {
        this.sentMsgsCnt = sentMsgsCnt;
    }

    public long getSentBytesCount() {
        return this.sentBytesCnt;
    }

    public void setSentBytesCount(long sentBytesCnt) {
        this.sentBytesCnt = sentBytesCnt;
    }

    public int getReceivedMessagesCount() {
        return this.rcvdMsgsCnt;
    }

    public void setReceivedMessagesCount(int rcvdMsgsCnt) {
        this.rcvdMsgsCnt = rcvdMsgsCnt;
    }

    public long getReceivedBytesCount() {
        return this.rcvdBytesCnt;
    }

    public void setReceivedBytesCount(long rcvdBytesCnt) {
        this.rcvdBytesCnt = rcvdBytesCnt;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        GridClientNodeMetricsBean other = (GridClientNodeMetricsBean)obj;
        return this.availProcs == other.availProcs && this.curActiveJobs == other.curActiveJobs && this.curCancelledJobs == other.curCancelledJobs && this.curIdleTime == other.curIdleTime && this.curJobExecTime == other.curJobExecTime && this.curJobWaitTime == other.curJobWaitTime && this.curRejectedJobs == other.curRejectedJobs && this.curWaitingJobs == other.curWaitingJobs && this.daemonThreadCnt == other.daemonThreadCnt && this.heapCommitted == other.heapCommitted && this.heapInit == other.heapInit && this.heapMax == other.heapMax && this.heapUsed == other.heapUsed && this.maxActiveJobs == other.maxActiveJobs && this.maxCancelledJobs == other.maxCancelledJobs && this.maxJobExecTime == other.maxJobExecTime && this.maxJobWaitTime == other.maxJobWaitTime && this.maxRejectedJobs == other.maxRejectedJobs && this.maxWaitingJobs == other.maxWaitingJobs && this.nonHeapCommitted == other.nonHeapCommitted && this.nonHeapInit == other.nonHeapInit && this.nonHeapMax == other.nonHeapMax && this.nonHeapUsed == other.nonHeapUsed && this.peakThreadCnt == other.peakThreadCnt && this.startTime == other.startTime && this.nodeStartTime == other.nodeStartTime && this.startedThreadCnt == other.startedThreadCnt && this.threadCnt == other.threadCnt && this.totalCancelledJobs == other.totalCancelledJobs && this.totalExecutedJobs == other.totalExecutedJobs && this.totalIdleTime == other.totalIdleTime && this.totalRejectedJobs == other.totalRejectedJobs && this.fileSysFreeSpace == other.fileSysFreeSpace && this.fileSysTotalSpace == other.fileSysTotalSpace && this.fileSysUsableSpace == other.fileSysUsableSpace && this.totalExecTasks == other.totalExecTasks && this.sentMsgsCnt == other.sentMsgsCnt && this.sentBytesCnt == other.sentBytesCnt && this.rcvdMsgsCnt == other.rcvdMsgsCnt && this.rcvdBytesCnt == other.rcvdBytesCnt && this.upTime == other.upTime;
    }

    public String toString() {
        return "GridClientNodeMetricsBean [lastUpdateTime=" + this.lastUpdateTime + ", maxActiveJobs=" + this.maxActiveJobs + ", curActiveJobs=" + this.curActiveJobs + ", avgActiveJobs=" + this.avgActiveJobs + ", maxWaitingJobs=" + this.maxWaitingJobs + ", curWaitingJobs=" + this.curWaitingJobs + ", avgWaitingJobs=" + this.avgWaitingJobs + ", maxRejectedJobs=" + this.maxRejectedJobs + ", curRejectedJobs=" + this.curRejectedJobs + ", avgRejectedJobs=" + this.avgRejectedJobs + ", maxCancelledJobs=" + this.maxCancelledJobs + ", curCancelledJobs=" + this.curCancelledJobs + ", avgCancelledJobs=" + this.avgCancelledJobs + ", totalRejectedJobs=" + this.totalRejectedJobs + ", totalCancelledJobs=" + this.totalCancelledJobs + ", totalExecutedJobs=" + this.totalExecutedJobs + ", maxJobWaitTime=" + this.maxJobWaitTime + ", curJobWaitTime=" + this.curJobWaitTime + ", avgJobWaitTime=" + this.avgJobWaitTime + ", maxJobExecTime=" + this.maxJobExecTime + ", curJobExecTime=" + this.curJobExecTime + ", avgJobExecTime=" + this.avgJobExecTime + ", totalExecTasks=" + this.totalExecTasks + ", totalIdleTime=" + this.totalIdleTime + ", curIdleTime=" + this.curIdleTime + ", availProcs=" + this.availProcs + ", load=" + this.load + ", avgLoad=" + this.avgLoad + ", gcLoad=" + this.gcLoad + ", heapInit=" + this.heapInit + ", heapUsed=" + this.heapUsed + ", heapCommitted=" + this.heapCommitted + ", heapMax=" + this.heapMax + ", nonHeapInit=" + this.nonHeapInit + ", nonHeapUsed=" + this.nonHeapUsed + ", nonHeapCommitted=" + this.nonHeapCommitted + ", nonHeapMax=" + this.nonHeapMax + ", upTime=" + this.upTime + ", startTime=" + this.startTime + ", nodeStartTime=" + this.nodeStartTime + ", threadCnt=" + this.threadCnt + ", peakThreadCnt=" + this.peakThreadCnt + ", startedThreadCnt=" + this.startedThreadCnt + ", daemonThreadCnt=" + this.daemonThreadCnt + ", fileSysFreeSpace=" + this.fileSysFreeSpace + ", fileSysTotalSpace=" + this.fileSysTotalSpace + ", fileSysUsableSpace=" + this.fileSysUsableSpace + ", lastDataVer=" + this.lastDataVer + ", sentMsgsCnt=" + this.sentMsgsCnt + ", sentBytesCnt=" + this.sentBytesCnt + ", rcvdMsgsCnt=" + this.rcvdMsgsCnt + ", rcvdBytesCnt=" + this.rcvdBytesCnt + "]";
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.lastUpdateTime);
        out.writeInt(this.maxActiveJobs);
        out.writeInt(this.curActiveJobs);
        out.writeFloat(this.avgActiveJobs);
        out.writeInt(this.maxWaitingJobs);
        out.writeInt(this.curWaitingJobs);
        out.writeFloat(this.avgWaitingJobs);
        out.writeInt(this.maxRejectedJobs);
        out.writeInt(this.curRejectedJobs);
        out.writeFloat(this.avgRejectedJobs);
        out.writeInt(this.maxCancelledJobs);
        out.writeInt(this.curCancelledJobs);
        out.writeFloat(this.avgCancelledJobs);
        out.writeInt(this.totalRejectedJobs);
        out.writeInt(this.totalCancelledJobs);
        out.writeInt(this.totalExecutedJobs);
        out.writeLong(this.maxJobWaitTime);
        out.writeLong(this.curJobWaitTime);
        out.writeDouble(this.avgJobWaitTime);
        out.writeLong(this.maxJobExecTime);
        out.writeLong(this.curJobExecTime);
        out.writeDouble(this.avgJobExecTime);
        out.writeInt(this.totalExecTasks);
        out.writeLong(this.totalIdleTime);
        out.writeLong(this.curIdleTime);
        out.writeInt(this.availProcs);
        out.writeDouble(this.load);
        out.writeDouble(this.avgLoad);
        out.writeDouble(this.gcLoad);
        out.writeLong(this.heapInit);
        out.writeLong(this.heapUsed);
        out.writeLong(this.heapCommitted);
        out.writeLong(this.heapMax);
        out.writeLong(this.nonHeapInit);
        out.writeLong(this.nonHeapUsed);
        out.writeLong(this.nonHeapCommitted);
        out.writeLong(this.nonHeapMax);
        out.writeLong(this.upTime);
        out.writeLong(this.startTime);
        out.writeLong(this.nodeStartTime);
        out.writeInt(this.threadCnt);
        out.writeInt(this.peakThreadCnt);
        out.writeLong(this.startedThreadCnt);
        out.writeInt(this.daemonThreadCnt);
        out.writeLong(this.fileSysFreeSpace);
        out.writeLong(this.fileSysTotalSpace);
        out.writeLong(this.fileSysUsableSpace);
        out.writeLong(this.lastDataVer);
        out.writeInt(this.sentMsgsCnt);
        out.writeLong(this.sentBytesCnt);
        out.writeInt(this.rcvdMsgsCnt);
        out.writeLong(this.rcvdBytesCnt);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.lastUpdateTime = in.readLong();
        this.maxActiveJobs = in.readInt();
        this.curActiveJobs = in.readInt();
        this.avgActiveJobs = in.readFloat();
        this.maxWaitingJobs = in.readInt();
        this.curWaitingJobs = in.readInt();
        this.avgWaitingJobs = in.readFloat();
        this.maxRejectedJobs = in.readInt();
        this.curRejectedJobs = in.readInt();
        this.avgRejectedJobs = in.readFloat();
        this.maxCancelledJobs = in.readInt();
        this.curCancelledJobs = in.readInt();
        this.avgCancelledJobs = in.readFloat();
        this.totalRejectedJobs = in.readInt();
        this.totalCancelledJobs = in.readInt();
        this.totalExecutedJobs = in.readInt();
        this.maxJobWaitTime = in.readLong();
        this.curJobWaitTime = in.readLong();
        this.avgJobWaitTime = in.readDouble();
        this.maxJobExecTime = in.readLong();
        this.curJobExecTime = in.readLong();
        this.avgJobExecTime = in.readDouble();
        this.totalExecTasks = in.readInt();
        this.totalIdleTime = in.readLong();
        this.curIdleTime = in.readLong();
        this.availProcs = in.readInt();
        this.load = in.readDouble();
        this.avgLoad = in.readDouble();
        this.gcLoad = in.readDouble();
        this.heapInit = in.readLong();
        this.heapUsed = in.readLong();
        this.heapCommitted = in.readLong();
        this.heapMax = in.readLong();
        this.nonHeapInit = in.readLong();
        this.nonHeapUsed = in.readLong();
        this.nonHeapCommitted = in.readLong();
        this.nonHeapMax = in.readLong();
        this.upTime = in.readLong();
        this.startTime = in.readLong();
        this.nodeStartTime = in.readLong();
        this.threadCnt = in.readInt();
        this.peakThreadCnt = in.readInt();
        this.startedThreadCnt = in.readLong();
        this.daemonThreadCnt = in.readInt();
        this.fileSysFreeSpace = in.readLong();
        this.fileSysTotalSpace = in.readLong();
        this.fileSysUsableSpace = in.readLong();
        this.lastDataVer = in.readLong();
        this.sentMsgsCnt = in.readInt();
        this.sentBytesCnt = in.readLong();
        this.rcvdMsgsCnt = in.readInt();
        this.rcvdBytesCnt = in.readLong();
    }
}

