/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.metastorage.persistence;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.function.LongFunction;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.processors.metastorage.persistence.DistributedMetaStorageHistoryItem;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;

final class DistributedMetaStorageVersion
extends IgniteDataTransferObject {
    private static final long serialVersionUID = 0L;
    public static final DistributedMetaStorageVersion INITIAL_VERSION = new DistributedMetaStorageVersion(0L, 1L);
    @GridToStringInclude
    private long id;
    @GridToStringInclude
    private long hash;

    private static long nextHash(long hash, DistributedMetaStorageHistoryItem update) {
        return hash * 31L + update.longHash();
    }

    public DistributedMetaStorageVersion() {
    }

    private DistributedMetaStorageVersion(long id, long hash) {
        this.id = id;
        this.hash = hash;
    }

    public DistributedMetaStorageVersion nextVersion(DistributedMetaStorageHistoryItem update) {
        return new DistributedMetaStorageVersion(this.id + 1L, DistributedMetaStorageVersion.nextHash(this.hash, update));
    }

    public DistributedMetaStorageVersion nextVersion(Collection<DistributedMetaStorageHistoryItem> updates) {
        long hash = this.hash;
        for (DistributedMetaStorageHistoryItem update : updates) {
            hash = DistributedMetaStorageVersion.nextHash(hash, update);
        }
        return new DistributedMetaStorageVersion(this.id + (long)updates.size(), hash);
    }

    public DistributedMetaStorageVersion nextVersion(DistributedMetaStorageHistoryItem[] updates, int fromIdx, int toIdx) {
        long hash = this.hash;
        for (int idx = fromIdx; idx < toIdx; ++idx) {
            hash = DistributedMetaStorageVersion.nextHash(hash, updates[idx]);
        }
        return new DistributedMetaStorageVersion(this.id + (long)toIdx - (long)fromIdx, hash);
    }

    public DistributedMetaStorageVersion nextVersion(LongFunction<DistributedMetaStorageHistoryItem> update, long fromVer, long toVer) {
        assert (fromVer <= toVer);
        long hash = this.hash;
        for (long idx = fromVer; idx <= toVer; ++idx) {
            hash = DistributedMetaStorageVersion.nextHash(hash, update.apply(idx));
        }
        return new DistributedMetaStorageVersion(this.id + toVer + 1L - fromVer, hash);
    }

    public long id() {
        return this.id;
    }

    public long hash() {
        return this.hash;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        out.writeLong(this.id);
        out.writeLong(this.hash);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException {
        this.id = in.readLong();
        this.hash = in.readLong();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DistributedMetaStorageVersion ver = (DistributedMetaStorageVersion)o;
        return this.id == ver.id && this.hash == ver.hash;
    }

    public int hashCode() {
        return 31 * Long.hashCode(this.id) + Long.hashCode(this.hash);
    }

    public String toString() {
        return S.toString(DistributedMetaStorageVersion.class, this);
    }
}

