/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.verify;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;

public class PartitionEntryHashRecord
implements Serializable {
    private static final long serialVersionUID = 0L;
    @GridToStringExclude
    private final int cacheId;
    private final String cacheName;
    @GridToStringExclude
    private final KeyCacheObject key;
    @GridToStringExclude
    private final String keyStr;
    private final byte[] keyBytes;
    private final GridCacheVersion ver;
    @GridToStringExclude
    private volatile CacheObject val;
    private volatile byte[] valBytes;
    @GridToStringExclude
    private volatile String valStr;
    @GridToStringExclude
    private final int valHash;

    public PartitionEntryHashRecord(int cacheId, String cacheName, KeyCacheObject key, String keyStr, byte[] keyBytes, GridCacheVersion ver, int valHash, CacheObject val, String valStr, byte[] valBytes) {
        this.cacheId = cacheId;
        this.cacheName = cacheName;
        this.key = key;
        this.keyStr = keyStr;
        this.keyBytes = keyBytes;
        this.ver = ver;
        this.val = val;
        this.valStr = valStr;
        this.valHash = valHash;
        this.valBytes = valBytes;
    }

    public PartitionEntryHashRecord(int cacheId, String cacheName, KeyCacheObject key, String keyStr, byte[] keyBytes, GridCacheVersion ver, int valHash) {
        this(cacheId, cacheName, key, keyStr, keyBytes, ver, valHash, null, null, null);
    }

    public int cacheId() {
        return this.cacheId;
    }

    public String cacheName() {
        return this.cacheName;
    }

    public KeyCacheObject key() {
        return this.key;
    }

    public byte[] keyBytes() {
        return this.keyBytes;
    }

    public GridCacheVersion version() {
        return this.ver;
    }

    public int valueHash() {
        return this.valHash;
    }

    public String keyString() {
        return this.keyStr;
    }

    public CacheObject value() {
        return this.val;
    }

    public void value(CacheObject val) {
        this.val = val;
    }

    public String valueString() {
        return this.valStr;
    }

    public void valueString(String valStr) {
        this.valStr = valStr;
    }

    public void valueBytes(byte[] valBytes) {
        this.valBytes = valBytes;
    }

    public byte[] valueBytes() {
        return this.valBytes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionEntryHashRecord that = (PartitionEntryHashRecord)o;
        if (this.cacheId != that.cacheId) {
            return false;
        }
        if (this.valHash != that.valHash) {
            return false;
        }
        if (!Arrays.equals(this.keyBytes, that.keyBytes)) {
            return false;
        }
        return this.ver != null ? this.ver.equals(that.ver) : that.ver == null;
    }

    public int hashCode() {
        int res = this.cacheId;
        res = 31 * res + Arrays.hashCode(this.keyBytes);
        res = 31 * res + (this.ver != null ? this.ver.hashCode() : 0);
        res = 31 * res + this.valHash;
        return res;
    }

    public String toString() {
        return S.toString(PartitionEntryHashRecord.class, this, "key", (Object)this.keyStr, "value", (Object)this.valStr, "keyBytes", (Object)(this.keyBytes != null ? U.byteArray2HexString(this.keyBytes) : null), "valueBytes", this.valBytes != null ? U.byteArray2HexString(this.valBytes) : null);
    }
}

