/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.transactions;

import java.nio.ByteBuffer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.IgniteCodeGeneratingFail;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectValueContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheOperation;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.Nullable;

@IgniteCodeGeneratingFail
public class TxEntryValueHolder
implements Message {
    private static final long serialVersionUID = 0L;
    @GridToStringInclude(sensitive=true)
    private CacheObject val;
    @GridToStringInclude
    private GridCacheOperation op = GridCacheOperation.NOOP;
    @GridToStringExclude
    private boolean hasWriteVal;
    @GridToStringExclude
    @GridDirectTransient
    private boolean hasReadVal;

    public void value(GridCacheOperation op, CacheObject val, boolean hasWriteVal, boolean hasReadVal) {
        if (hasReadVal && this.hasWriteVal) {
            return;
        }
        this.op = op;
        this.val = val;
        this.hasWriteVal = hasWriteVal || op == GridCacheOperation.CREATE || op == GridCacheOperation.UPDATE || op == GridCacheOperation.DELETE;
        this.hasReadVal = hasReadVal || op == GridCacheOperation.READ;
    }

    public boolean hasValue() {
        return this.hasWriteVal || this.hasReadVal;
    }

    public CacheObject value() {
        return this.val;
    }

    public void value(@Nullable CacheObject val) {
        this.val = val;
    }

    public GridCacheOperation op() {
        return this.op;
    }

    public void op(GridCacheOperation op) {
        this.op = op;
    }

    public boolean hasWriteValue() {
        return this.hasWriteVal;
    }

    public boolean hasReadValue() {
        return this.hasReadVal;
    }

    public void marshal(GridCacheContext<?, ?> ctx) throws IgniteCheckedException {
        if (this.hasWriteVal && this.val != null) {
            this.val.prepareMarshal(ctx.cacheObjectContext());
        }
    }

    public void unmarshal(CacheObjectValueContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        if (this.hasWriteVal && this.val != null) {
            this.val.finishUnmarshal(ctx, ldr);
        }
    }

    @Override
    public void onAckReceived() {
    }

    public String toString() {
        return S.toString(TxEntryValueHolder.class, this);
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeBoolean("hasWriteVal", this.hasWriteVal)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeByte("op", this.op != null ? (byte)this.op.ordinal() : (byte)-1)) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                if (!writer.writeMessage("val", this.hasWriteVal ? this.val : null)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.hasWriteVal = reader.readBoolean("hasWriteVal");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                byte opOrd = reader.readByte("op");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.op = GridCacheOperation.fromOrdinal(opOrd);
                reader.incrementState();
            }
            case 2: {
                this.val = (CacheObject)reader.readMessage("val");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(TxEntryValueHolder.class);
    }

    @Override
    public short directType() {
        return 101;
    }

    @Override
    public byte fieldsCount() {
        return 3;
    }
}

