/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.metastorage;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetastorageBPlusIO;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetastorageDataRow;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetastorageRow;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetastorageRowStore;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusIO;
import org.apache.ignite.internal.util.GridUnsafe;

public class MetastoragePageIOUtils {
    public static <IO extends BPlusIO<MetastorageRow>> long getLink(IO io, long pageAddr, int idx) {
        assert (idx < io.getCount(pageAddr)) : idx;
        return PageUtils.getLong(pageAddr, io.offset(idx));
    }

    public static <IO extends BPlusIO<MetastorageRow>> short getKeySize(IO io, long pageAddr, int idx) {
        return PageUtils.getShort(pageAddr, io.offset(idx) + 8);
    }

    public static <IO extends BPlusIO<MetastorageRow>> String getKey(IO io, long pageAddr, int idx, MetastorageRowStore rowStore) throws IgniteCheckedException {
        int off = io.offset(idx);
        short len = PageUtils.getShort(pageAddr, off + 8);
        if (len > 64) {
            long keyLink = PageUtils.getLong(pageAddr, off + 10);
            byte[] keyBytes = rowStore.readRow(keyLink);
            assert (keyBytes != null) : "[pageAddr=" + Long.toHexString(pageAddr) + ", idx=" + idx + "]";
            return new String(keyBytes);
        }
        byte[] keyBytes = PageUtils.getBytes(pageAddr, off + 10, len);
        return new String(keyBytes);
    }

    public static <IO extends BPlusIO<MetastorageRow>> MetastorageDataRow getDataRow(IO io, long pageAddr, int idx, MetastorageRowStore rowStore) throws IgniteCheckedException {
        long link = ((MetastorageBPlusIO)((Object)io)).getLink(pageAddr, idx);
        int off = io.offset(idx);
        short len = PageUtils.getShort(pageAddr, off + 8);
        if (len > 64) {
            long keyLink = PageUtils.getLong(pageAddr, off + 10);
            byte[] keyBytes = rowStore.readRow(keyLink);
            assert (keyBytes != null) : "[pageAddr=" + Long.toHexString(pageAddr) + ", idx=" + idx + "]";
            return new MetastorageDataRow(link, new String(keyBytes), keyLink);
        }
        byte[] keyBytes = PageUtils.getBytes(pageAddr, off + 10, len);
        return new MetastorageDataRow(link, new String(keyBytes), 0L);
    }

    public static <IO extends BPlusIO<MetastorageRow>> void store(IO dstIo, long dstPageAddr, int dstIdx, BPlusIO<MetastorageRow> srcIo, long srcPageAddr, int srcIdx) {
        int srcOff = srcIo.offset(srcIdx);
        int dstOff = dstIo.offset(dstIdx);
        GridUnsafe.copyMemory(srcPageAddr + (long)srcOff, dstPageAddr + (long)dstOff, 74L);
    }

    public static <IO extends BPlusIO<MetastorageRow>> void storeByOffset(IO io, long pageAddr, int off, MetastorageRow row) {
        assert (row.link() != 0L);
        PageUtils.putLong(pageAddr, off, row.link());
        byte[] bytes = row.key().getBytes();
        assert (bytes.length <= Short.MAX_VALUE);
        if (row.keyLink() != 0L) {
            PageUtils.putShort(pageAddr, off + 8, (short)bytes.length);
            PageUtils.putLong(pageAddr, off + 10, row.keyLink());
        } else {
            assert (bytes.length <= 64);
            PageUtils.putShort(pageAddr, off + 8, (short)bytes.length);
            PageUtils.putBytes(pageAddr, off + 10, bytes);
        }
    }
}

