/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.management.api.CommandUtils;
import org.apache.ignite.internal.management.api.ComputeCommand;
import org.apache.ignite.internal.management.cache.CacheIndexesListCommandArg;
import org.apache.ignite.internal.management.cache.IndexListInfoContainer;
import org.apache.ignite.internal.management.cache.IndexListTask;

public class CacheIndexesListCommand
implements ComputeCommand<CacheIndexesListCommandArg, Set<IndexListInfoContainer>> {
    @Override
    public String description() {
        return "List all indexes that match specified filters";
    }

    @Override
    public Class<CacheIndexesListCommandArg> argClass() {
        return CacheIndexesListCommandArg.class;
    }

    @Override
    public Class<IndexListTask> taskClass() {
        return IndexListTask.class;
    }

    @Override
    public Collection<GridClientNode> nodes(Collection<GridClientNode> nodes, CacheIndexesListCommandArg arg) {
        return CommandUtils.nodeOrNull(arg.nodeId(), nodes);
    }

    @Override
    public void printResult(CacheIndexesListCommandArg arg, Set<IndexListInfoContainer> res, Consumer<String> printer) {
        ArrayList<IndexListInfoContainer> sorted = new ArrayList<IndexListInfoContainer>(res);
        sorted.sort(IndexListInfoContainer.comparator());
        String prevGrpName = "";
        for (IndexListInfoContainer container : sorted) {
            if (!prevGrpName.equals(container.groupName())) {
                prevGrpName = container.groupName();
                printer.accept("");
            }
            printer.accept(container.toString());
        }
        printer.accept("");
    }
}

