/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index.sorted.keys;

import java.math.BigDecimal;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.keys.IndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.NumericIndexKey;

public class DecimalIndexKey
extends NumericIndexKey {
    private final BigDecimal key;

    public DecimalIndexKey(BigDecimal key) {
        this.key = key;
    }

    @Override
    public Object key() {
        return this.key;
    }

    @Override
    public IndexKeyType type() {
        return IndexKeyType.DECIMAL;
    }

    @Override
    public int compareTo(boolean val) {
        return Boolean.compare(this.key.compareTo(BigDecimal.ZERO) != 0, val);
    }

    @Override
    public int compareTo(byte val) {
        return this.key.compareTo(BigDecimal.valueOf(val));
    }

    @Override
    public int compareTo(short val) {
        return this.key.compareTo(BigDecimal.valueOf(val));
    }

    @Override
    public int compareTo(int val) {
        return this.key.compareTo(BigDecimal.valueOf(val));
    }

    @Override
    public int compareTo(long val) {
        return this.key.compareTo(BigDecimal.valueOf(val));
    }

    @Override
    public int compareTo(float val) {
        return this.key.compareTo(BigDecimal.valueOf(val));
    }

    @Override
    public int compareTo(double val) {
        return this.key.compareTo(BigDecimal.valueOf(val));
    }

    @Override
    public int compareTo(BigDecimal val) {
        return this.key.compareTo(val);
    }

    @Override
    public int compare(IndexKey o) {
        return -((NumericIndexKey)o).compareTo(this.key);
    }

    public String toString() {
        return String.valueOf(this.key);
    }
}

