/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.binary.streams;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.ignite.internal.binary.streams.BinaryInputStream;

public class BinaryByteBufferInputStream
implements BinaryInputStream {
    private final ByteBuffer buf;

    public static BinaryByteBufferInputStream create(ByteBuffer buf) {
        return new BinaryByteBufferInputStream(buf);
    }

    BinaryByteBufferInputStream(ByteBuffer buf) {
        this.buf = buf;
    }

    @Override
    public byte readByte() {
        return this.buf.get();
    }

    @Override
    public byte[] readByteArray(int cnt) {
        byte[] data = new byte[cnt];
        this.buf.get(data);
        return data;
    }

    @Override
    public int read(byte[] arr, int off, int cnt) {
        return 0;
    }

    @Override
    public boolean readBoolean() {
        return this.readByte() == 1;
    }

    @Override
    public boolean[] readBooleanArray(int cnt) {
        boolean[] res = new boolean[cnt];
        for (int i = 0; i < cnt; ++i) {
            res[i] = this.buf.get() != 0;
        }
        return res;
    }

    @Override
    public short readShort() {
        return this.buf.getShort();
    }

    @Override
    public short[] readShortArray(int cnt) {
        short[] res = new short[cnt];
        for (int i = 0; i < cnt; ++i) {
            res[i] = this.buf.getShort();
        }
        return res;
    }

    @Override
    public char readChar() {
        return this.buf.getChar();
    }

    @Override
    public char[] readCharArray(int cnt) {
        char[] res = new char[cnt];
        for (int i = 0; i < cnt; ++i) {
            res[i] = this.buf.getChar();
        }
        return res;
    }

    @Override
    public int readInt() {
        return this.buf.getInt();
    }

    @Override
    public int[] readIntArray(int cnt) {
        int[] res = new int[cnt];
        for (int i = 0; i < cnt; ++i) {
            res[i] = this.buf.getInt();
        }
        return res;
    }

    @Override
    public float readFloat() {
        return this.buf.getFloat();
    }

    @Override
    public float[] readFloatArray(int cnt) {
        float[] res = new float[cnt];
        for (int i = 0; i < cnt; ++i) {
            res[i] = this.buf.getFloat();
        }
        return res;
    }

    @Override
    public long readLong() {
        return this.buf.getLong();
    }

    @Override
    public long[] readLongArray(int cnt) {
        long[] res = new long[cnt];
        for (int i = 0; i < cnt; ++i) {
            res[i] = this.buf.getLong();
        }
        return res;
    }

    @Override
    public double readDouble() {
        return this.buf.getDouble();
    }

    @Override
    public double[] readDoubleArray(int cnt) {
        double[] res = new double[cnt];
        for (int i = 0; i < cnt; ++i) {
            res[i] = this.buf.getDouble();
        }
        return res;
    }

    @Override
    public int remaining() {
        return this.buf.remaining();
    }

    @Override
    public byte readBytePositioned(int pos) {
        return this.buf.get(pos);
    }

    @Override
    public short readShortPositioned(int pos) {
        return this.buf.getShort(pos);
    }

    @Override
    public int readIntPositioned(int pos) {
        return this.buf.getInt(pos);
    }

    @Override
    public int position() {
        return this.buf.position();
    }

    @Override
    public void position(int pos) {
        this.buf.position(pos);
    }

    @Override
    public long rawOffheapPointer() {
        return 0L;
    }

    @Override
    public int capacity() {
        return this.buf.capacity();
    }

    @Override
    public byte[] array() {
        return this.buf.array();
    }

    @Override
    public byte[] arrayCopy() {
        byte[] arr = this.buf.array();
        return Arrays.copyOf(arr, arr.length);
    }

    @Override
    public long offheapPointer() {
        return 0L;
    }

    @Override
    public boolean hasArray() {
        return false;
    }
}

