/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.configuration;

import java.io.Serializable;
import org.apache.ignite.internal.util.typedef.internal.A;

public class EncryptionConfiguration
implements Serializable {
    private static final long serialVersionUID = 0L;
    public static final double DFLT_REENCRYPTION_RATE_MBPS = 0.0;
    public static final int DFLT_REENCRYPTION_BATCH_SIZE = 100;
    private double reencryptionRateLimit = 0.0;
    private int reencryptionBatchSize = 100;

    public EncryptionConfiguration() {
    }

    public EncryptionConfiguration(EncryptionConfiguration cfg) {
        assert (cfg != null);
        this.reencryptionBatchSize = cfg.getReencryptionBatchSize();
        this.reencryptionRateLimit = cfg.getReencryptionRateLimit();
    }

    public double getReencryptionRateLimit() {
        return this.reencryptionRateLimit;
    }

    public EncryptionConfiguration setReencryptionRateLimit(double reencryptionRateLimit) {
        A.ensure(reencryptionRateLimit >= 0.0, "Re-encryption rate limit (" + reencryptionRateLimit + ") must be non-negative.");
        this.reencryptionRateLimit = reencryptionRateLimit;
        return this;
    }

    public int getReencryptionBatchSize() {
        return this.reencryptionBatchSize;
    }

    public EncryptionConfiguration setReencryptionBatchSize(int reencryptionBatchSize) {
        A.ensure(reencryptionBatchSize > 0, "Reencryption batch size(" + reencryptionBatchSize + ") must be positive.");
        this.reencryptionBatchSize = reencryptionBatchSize;
        return this;
    }
}

