/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.rule.logical;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexSimplify;
import org.apache.calcite.rex.RexUtil;
import org.apache.ignite.internal.processors.query.calcite.rel.ProjectableFilterableTableScan;
import org.apache.ignite.internal.processors.query.calcite.rel.logical.IgniteLogicalIndexScan;
import org.apache.ignite.internal.processors.query.calcite.rel.logical.IgniteLogicalTableScan;
import org.apache.ignite.internal.processors.query.calcite.rule.logical.ImmutableFilterScanMergeRule;
import org.apache.ignite.internal.processors.query.calcite.rule.logical.RuleFactoryConfig;
import org.apache.ignite.internal.processors.query.calcite.schema.IgniteTable;
import org.apache.ignite.internal.processors.query.calcite.util.RexUtils;
import org.apache.ignite.internal.util.typedef.F;
import org.immutables.value.Value;
import org.jetbrains.annotations.Nullable;

@Value.Enclosing
public abstract class FilterScanMergeRule<T extends ProjectableFilterableTableScan>
extends RelRule<Config> {
    public static final RelOptRule INDEX_SCAN = Config.INDEX_SCAN.toRule();
    public static final RelOptRule TABLE_SCAN = Config.TABLE_SCAN.toRule();
    public static final RelOptRule TABLE_SCAN_SKIP_CORRELATED = Config.TABLE_SCAN_SKIP_CORRELATED.toRule();

    private FilterScanMergeRule(Config config) {
        super((RelRule.Config)config);
    }

    public void onMatch(RelOptRuleCall call) {
        LogicalFilter filter = (LogicalFilter)call.rel(0);
        final ProjectableFilterableTableScan scan = (ProjectableFilterableTableScan)call.rel(1);
        RelOptCluster cluster = scan.getCluster();
        RexBuilder builder = RexUtils.builder(cluster);
        RexNode remainCondition = null;
        RexNode condition = filter.getCondition();
        if (((Config)this.config).isSkipCorrelated() && RexUtils.hasCorrelation(condition)) {
            RexNode cnf = RexUtil.toCnf((RexBuilder)builder, (RexNode)condition);
            List conjunctions = RelOptUtil.conjunctions((RexNode)cnf);
            ArrayList<RexNode> correlated = new ArrayList<RexNode>();
            ArrayList<RexNode> notCorrelated = new ArrayList<RexNode>();
            for (RexNode node : conjunctions) {
                if (RexUtils.hasCorrelation(node)) {
                    correlated.add(node);
                    continue;
                }
                notCorrelated.add(node);
            }
            if (notCorrelated.isEmpty()) {
                return;
            }
            if (!correlated.isEmpty()) {
                remainCondition = RexUtil.composeConjunction((RexBuilder)builder, correlated);
                condition = RexUtil.composeConjunction((RexBuilder)builder, notCorrelated);
            }
        }
        if (scan.projects() != null) {
            RexShuttle shuttle = new RexShuttle(){

                public RexNode visitInputRef(RexInputRef ref) {
                    return scan.projects().get(ref.getIndex());
                }
            };
            condition = shuttle.apply(condition);
        }
        if (scan.condition() != null) {
            condition = RexUtil.composeConjunction((RexBuilder)builder, (Iterable)F.asList((Object[])new RexNode[]{scan.condition(), condition}));
        }
        condition = RexUtils.replaceLocalRefs(condition);
        condition = new RexSimplify(builder, RelOptPredicateList.EMPTY, call.getPlanner().getExecutor()).simplifyUnknownAsFalse(condition);
        condition = RexUtils.replaceInputRefs(condition);
        RelTraitSet trait = cluster.traitSet();
        ProjectableFilterableTableScan res = this.createNode(cluster, scan, trait, condition);
        if (res == null) {
            return;
        }
        if (remainCondition != null) {
            res = call.builder().push((RelNode)res).filter(new RexNode[]{remainCondition}).build();
        }
        call.transformTo((RelNode)res);
    }

    @Nullable
    protected abstract T createNode(RelOptCluster var1, T var2, RelTraitSet var3, RexNode var4);

    @Value.Immutable(singleton=false)
    public static interface Config
    extends RuleFactoryConfig<Config> {
        public static final Config DEFAULT = ImmutableFilterScanMergeRule.Config.builder().withRuleFactory((Config x$0) -> new FilterTableScanMergeRule((Config)x$0)).build();
        public static final Config TABLE_SCAN = DEFAULT.withScanRuleConfig(IgniteLogicalTableScan.class, "FilterTableScanMergeRule");
        public static final Config TABLE_SCAN_SKIP_CORRELATED = DEFAULT.withScanRuleConfig(IgniteLogicalTableScan.class, "FilterTableScanMergeSkipCorrelatedRule").withSkipCorrelated(true);
        public static final Config INDEX_SCAN = DEFAULT.withRuleFactory(x$0 -> new FilterIndexScanMergeRule((Config)x$0)).withScanRuleConfig(IgniteLogicalIndexScan.class, "FilterIndexScanMergeRule");

        default public Config withScanRuleConfig(Class<? extends ProjectableFilterableTableScan> scanCls, String desc) {
            return (Config)this.withDescription(desc).withOperandSupplier(b -> b.operand(LogicalFilter.class).oneInput(b1 -> b1.operand(scanCls).noInputs())).as(Config.class);
        }

        @Value.Default
        default public boolean isSkipCorrelated() {
            return false;
        }

        public Config withSkipCorrelated(boolean var1);
    }

    private static class FilterTableScanMergeRule
    extends FilterScanMergeRule<IgniteLogicalTableScan> {
        private FilterTableScanMergeRule(Config cfg) {
            super(cfg);
        }

        @Override
        protected IgniteLogicalTableScan createNode(RelOptCluster cluster, IgniteLogicalTableScan scan, RelTraitSet traits, RexNode cond) {
            return IgniteLogicalTableScan.create(cluster, traits, scan.getTable(), (List<RelHint>)scan.getHints(), scan.projects(), cond, scan.requiredColumns());
        }
    }

    private static class FilterIndexScanMergeRule
    extends FilterScanMergeRule<IgniteLogicalIndexScan> {
        private FilterIndexScanMergeRule(Config cfg) {
            super(cfg);
        }

        @Override
        @Nullable
        protected IgniteLogicalIndexScan createNode(RelOptCluster cluster, IgniteLogicalIndexScan scan, RelTraitSet traits, RexNode cond) {
            if (((IgniteTable)scan.getTable().unwrap(IgniteTable.class)).isIndexRebuildInProgress()) {
                cluster.getPlanner().prune((RelNode)scan);
                return null;
            }
            return IgniteLogicalIndexScan.create(cluster, traits, scan.getTable(), scan.indexName(), scan.projects(), cond, scan.requiredColumns());
        }
    }
}

