/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.prepare;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.externalize.RelWriterImpl;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.performancestatistics.PerformanceStatisticsProcessor;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.processors.query.calcite.prepare.bounds.SearchBounds;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteRel;
import org.apache.ignite.internal.util.typedef.F;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PlanExtractor {
    private final PerformanceStatisticsProcessor perfStatProc;

    public PlanExtractor(GridKernalContext ctx) {
        this.perfStatProc = ctx.performanceStatistics();
    }

    public String extract(IgniteRel rel) {
        if (QueryUtils.INCLUDE_SENSITIVE) {
            return RelOptUtil.toString((RelNode)rel, (SqlExplainLevel)SqlExplainLevel.ALL_ATTRIBUTES);
        }
        StringWriter sw = new StringWriter();
        SensitiveDataAwarePlanWriter planWriter = new SensitiveDataAwarePlanWriter(new PrintWriter(sw));
        rel.explain((RelWriter)planWriter);
        return sw.toString();
    }

    private static class SensitiveDataAwarePlanWriter
    extends RelWriterImpl {
        public SensitiveDataAwarePlanWriter(PrintWriter pw) {
            super(pw, SqlExplainLevel.ALL_ATTRIBUTES, false);
        }

        public RelWriter item(String term, @Nullable Object val) {
            return super.item(term, this.removeSensitive(val));
        }

        private Object removeSensitive(Object val) {
            if (val instanceof RexNode) {
                return LiteralRemoveShuttle.INSTANCE.apply((RexNode)val);
            }
            if (val instanceof Collection) {
                return F.transform((Collection)((Collection)val), this::removeSensitive);
            }
            if (val instanceof SearchBounds) {
                return ((SearchBounds)val).transform(arg_0 -> ((LiteralRemoveShuttle)LiteralRemoveShuttle.INSTANCE).apply(arg_0));
            }
            return val;
        }

        public boolean nest() {
            return true;
        }
    }

    private static final class LiteralRemoveShuttle
    extends RexShuttle {
        private static final LiteralRemoveShuttle INSTANCE = new LiteralRemoveShuttle();

        private LiteralRemoveShuttle() {
        }

        public RexNode visitLiteral(RexLiteral literal) {
            return new RexDynamicParam(literal.getType(), -1);
        }
    }
}

