/*
 * Decompiled with CFR 0.152.
 */
package sqlline;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.text.ChoiceFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.function.Supplier;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jline.keymap.KeyMap;
import org.jline.reader.Completer;
import org.jline.reader.EndOfFileException;
import org.jline.reader.Highlighter;
import org.jline.reader.History;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.Parser;
import org.jline.reader.UserInterruptException;
import org.jline.reader.Widget;
import org.jline.reader.impl.history.DefaultHistory;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import sqlline.Application;
import sqlline.AttributedStyles;
import sqlline.BufferedRows;
import sqlline.BuiltInProperty;
import sqlline.CommandHandler;
import sqlline.Commands;
import sqlline.ConnectionMetadata;
import sqlline.DatabaseConnection;
import sqlline.DatabaseConnections;
import sqlline.Dialect;
import sqlline.DialectImpl;
import sqlline.DispatchCallback;
import sqlline.HighlightStyle;
import sqlline.IncrementalRows;
import sqlline.OutputFile;
import sqlline.OutputFormat;
import sqlline.PromptHandler;
import sqlline.Reflector;
import sqlline.Rows;
import sqlline.SeparatedValuesOutputFormat;
import sqlline.SqlLineCommandCompleter;
import sqlline.SqlLineCompleter;
import sqlline.SqlLineHighlighter;
import sqlline.SqlLineOpts;
import sqlline.SqlLineParser;
import sqlline.SqlLineSignalHandler;
import sqlline.WrappedSqlException;

public class SqlLine {
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle(SqlLine.class.getName(), Locale.ROOT);
    private static final String SEPARATOR = System.getProperty("line.separator");
    private boolean exit = false;
    private boolean prompting = false;
    private final DatabaseConnections connections = new DatabaseConnections();
    public static final String COMMAND_PREFIX = "!";
    private Set<Driver> drivers = null;
    private String lastProgress = null;
    private final Map<SQLWarning, Date> seenWarnings = new HashMap<SQLWarning, Date>();
    private final Commands commands = new Commands(this);
    private OutputFile scriptOutputFile = null;
    private OutputFile recordOutputFile = null;
    private PrintStream outputStream;
    private PrintStream errorStream;
    private LineReader lineReader;
    private List<String> batch = null;
    private final Reflector reflector;
    private Application application;
    private Config appConfig;
    private final ConnectionMetadata connectionMetadata = new ConnectionMetadata(this);
    public static final String SQLLINE_BASE_DIR = "x.sqlline.basedir";
    private static boolean initComplete = false;
    private final SqlLineSignalHandler signalHandler;
    private final Completer sqlLineCommandCompleter;
    private static final int SPACE = 0;
    private static final int DOT_SPACE = 1;
    private static final int QUOTED = 2;
    private static final int UNQUOTED = 3;

    static Manifest getManifest() throws IOException {
        URL base = SqlLine.class.getResource("/META-INF/MANIFEST.MF");
        URLConnection c = base.openConnection();
        if (c instanceof JarURLConnection) {
            return ((JarURLConnection)c).getManifest();
        }
        return null;
    }

    static String getManifestAttribute(String name) {
        try {
            Manifest m = SqlLine.getManifest();
            if (m == null) {
                return "??";
            }
            Attributes attrs = m.getAttributes("sqlline");
            if (attrs == null) {
                return "???";
            }
            String val = attrs.getValue(name);
            if (val == null || "".equals(val)) {
                return "????";
            }
            return val;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "?????";
        }
    }

    String getApplicationTitle() {
        try {
            return this.application.getInfoMessage();
        }
        catch (Exception e) {
            this.handleException(e);
            return "sqlline version ???";
        }
    }

    String getVersion() {
        try {
            return this.application.getVersion();
        }
        catch (Exception e) {
            this.handleException(e);
            return "sqlline version ???";
        }
    }

    static String getApplicationContactInformation() {
        return SqlLine.getManifestAttribute("Implementation-Vendor");
    }

    String loc(String res, int param) {
        try {
            return new MessageFormat(new ChoiceFormat(RESOURCE_BUNDLE.getString(res)).format(param), Locale.ROOT).format(new Object[]{param});
        }
        catch (Exception e) {
            return res + ": " + param;
        }
    }

    String loc(String res, Object ... params) {
        return SqlLine.locStatic(RESOURCE_BUNDLE, this.getErrorStream(), res, params);
    }

    static String locStatic(ResourceBundle resourceBundle, PrintStream err, String res, Object ... params) {
        try {
            return new MessageFormat(resourceBundle.getString(res), Locale.ROOT).format(params);
        }
        catch (Exception e) {
            e.printStackTrace(err);
            try {
                return res + ": " + Arrays.toString(params);
            }
            catch (Exception e2) {
                return res;
            }
        }
    }

    protected String locElapsedTime(long milliseconds) {
        return this.loc("time-ms", (double)milliseconds / 1000.0);
    }

    public static void main(String[] args) throws IOException {
        SqlLine.start(args, null, true);
    }

    public static Status mainWithInputRedirection(String[] args, InputStream inputStream) throws IOException {
        return SqlLine.start(args, inputStream, false);
    }

    public SqlLine() {
        this.setAppConfig(new Application());
        try {
            this.outputStream = new PrintStream((OutputStream)System.out, true, StandardCharsets.UTF_8.name());
            this.errorStream = new PrintStream((OutputStream)System.err, true, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            this.handleException(e);
        }
        this.reflector = new Reflector(this);
        this.getOpts().loadProperties(System.getProperties());
        this.sqlLineCommandCompleter = new SqlLineCommandCompleter(this);
        this.signalHandler = new SqlLineSignalHandler();
    }

    public static Status start(String[] args, InputStream inputStream, boolean saveHistory) throws IOException {
        SqlLine sqlline = new SqlLine();
        Status status = sqlline.begin(args, inputStream, saveHistory);
        if (!Boolean.getBoolean("sqlline.system.exit")) {
            System.exit(status.ordinal());
        }
        return status;
    }

    DatabaseConnection getDatabaseConnection() {
        return this.connections.current();
    }

    Connection getConnection() {
        if (this.getDatabaseConnections().current() == null) {
            throw new IllegalArgumentException(this.loc("no-current-connection", new Object[0]));
        }
        if (this.getDatabaseConnections().current().connection == null) {
            throw new IllegalArgumentException(this.loc("no-current-connection", new Object[0]));
        }
        return this.getDatabaseConnections().current().connection;
    }

    DatabaseMetaData getDatabaseMetaData() {
        if (this.getDatabaseConnections().current() == null) {
            throw new IllegalArgumentException(this.loc("no-current-connection", new Object[0]));
        }
        if (this.getDatabaseConnections().current().getDatabaseMetaData() == null) {
            throw new IllegalArgumentException(this.loc("no-current-connection", new Object[0]));
        }
        return this.connections.current().getDatabaseMetaData();
    }

    void registerKnownDrivers() {
        if (this.appConfig.allowedDrivers == null) {
            return;
        }
        for (String driverName : this.appConfig.allowedDrivers) {
            try {
                Class.forName(driverName);
            }
            catch (Throwable throwable) {}
        }
    }

    Status initArgs(String[] args, DispatchCallback callback) {
        LinkedList<String> commands = new LinkedList<String>();
        LinkedList<String> files = new LinkedList<String>();
        String driver = null;
        String user = null;
        String pass = null;
        String url = null;
        String nickname = null;
        String logFile = null;
        String commandHandler = null;
        String appConfig = null;
        String promptHandler = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("--help") || args[i].equals("-h")) {
                return Status.ARGS;
            }
            if (args[i].startsWith("--")) {
                boolean ret;
                String[] parts = this.split(args[i].substring(2), "=");
                this.debug(this.loc("setting-prop", Arrays.asList(parts)));
                if (parts.length <= 0 || (ret = parts.length >= 2 ? this.getOpts().set(parts[0], parts[1], true) : this.getOpts().set(parts[0], "true", true))) continue;
                return Status.ARGS;
            }
            if (args[i].charAt(0) == '-') {
                if (i == args.length - 1) {
                    return Status.ARGS;
                }
                if (args[i].equals("-d")) {
                    driver = args[++i];
                    continue;
                }
                if (args[i].equals("-ch")) {
                    commandHandler = args[++i];
                    continue;
                }
                if (args[i].equals("-n")) {
                    user = args[++i];
                    continue;
                }
                if (args[i].equals("-p")) {
                    pass = args[++i];
                    continue;
                }
                if (args[i].equals("-u")) {
                    url = args[++i];
                    continue;
                }
                if (args[i].equals("-e")) {
                    commands.add(args[++i]);
                    continue;
                }
                if (args[i].equals("-f")) {
                    this.getOpts().setRun(args[++i]);
                    continue;
                }
                if (args[i].equals("-log")) {
                    logFile = args[++i];
                    continue;
                }
                if (args[i].equals("-nn")) {
                    nickname = args[++i];
                    continue;
                }
                if (args[i].equals("-ac")) {
                    appConfig = args[++i];
                    continue;
                }
                if (args[i].equals("-ph")) {
                    promptHandler = args[++i];
                    continue;
                }
                return Status.ARGS;
            }
            files.add(args[i]);
        }
        if (appConfig != null) {
            this.dispatch("!appconfig " + appConfig, new DispatchCallback());
        }
        if (url != null || user != null || pass != null || driver != null) {
            String com = "!connect " + (driver == null || driver.trim().isEmpty() ? "" : "-p driver " + driver + " ") + (user == null ? "" : "-p user " + this.escapeAndQuote(user) + " ") + (pass == null ? "" : "-p password " + this.escapeAndQuote(pass) + " ") + this.escapeAndQuote(url);
            this.debug("issuing: " + com);
            this.dispatch(com, new DispatchCallback());
        }
        if (nickname != null) {
            this.dispatch("!nickname " + this.escapeAndQuote(nickname), new DispatchCallback());
        }
        if (logFile != null) {
            this.dispatch("!record " + this.escapeAndQuote(logFile), new DispatchCallback());
        }
        if (commandHandler != null) {
            StringBuilder sb = new StringBuilder();
            for (String chElem : commandHandler.split(",")) {
                sb.append(chElem).append(" ");
            }
            this.dispatch("!commandhandler " + sb.toString(), new DispatchCallback());
        }
        if (promptHandler != null) {
            this.dispatch("!prompthandler " + promptHandler, new DispatchCallback());
        }
        for (String file : files) {
            this.dispatch("!properties " + file, new DispatchCallback());
        }
        if (commands.size() > 0) {
            this.getOpts().set(BuiltInProperty.COLOR, false);
            this.getOpts().set(BuiltInProperty.HEADER_INTERVAL, -1);
            for (String command : commands) {
                this.debug(this.loc("executing-command", command));
                this.dispatch(command, new DispatchCallback());
            }
            this.exit = true;
        }
        Status status = Status.OK;
        if (this.getOpts().getRun() != null) {
            this.dispatch("!run \"" + this.getOpts().getRun() + "\"", callback);
            if (callback.isFailure()) {
                status = Status.OTHER;
            }
            this.dispatch("!quit", new DispatchCallback());
        }
        return status;
    }

    public Status begin(String[] args, InputStream inputStream, boolean saveHistory) throws IOException {
        LineReader reader;
        boolean runningScript;
        try {
            this.getOpts().load();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        DefaultHistory fileHistory = new DefaultHistory();
        boolean bl = runningScript = this.getOpts().getRun() != null;
        if (runningScript) {
            try {
                FileInputStream scriptStream = new FileInputStream(this.getOpts().getRun());
                reader = this.getConsoleReader(scriptStream, (History)fileHistory);
            }
            catch (Throwable t) {
                this.handleException(t);
                this.commands.quit(null, new DispatchCallback());
                return Status.OTHER;
            }
        } else {
            reader = this.getConsoleReader(inputStream, (History)fileHistory);
        }
        DispatchCallback callback = new DispatchCallback();
        Status status = this.initArgs(args, callback);
        switch (status) {
            case ARGS: {
                this.usage();
            }
            case OTHER: {
                return status;
            }
        }
        try {
            this.info(this.getApplicationTitle());
        }
        catch (Exception e) {
            this.handleException(e);
        }
        initComplete = true;
        Terminal terminal = this.lineReader.getTerminal();
        while (!this.exit) {
            try {
                this.signalHandler.setCallback(callback);
                this.dispatch(reader.readLine(this.getPromptHandler().getPrompt().toAnsi(terminal), this.getPromptHandler().getRightPrompt().toAnsi(terminal), (Character)null, null), callback);
                if (saveHistory) {
                    fileHistory.save();
                }
                if (callback.isSuccess() || !runningScript) continue;
                this.commands.quit(null, callback);
                status = Status.OTHER;
            }
            catch (EndOfFileException eof) {
                this.commands.quit(null, callback);
            }
            catch (UserInterruptException ioe) {
                try {
                    callback.forceKillSqlQuery();
                    callback.setToCancel();
                    this.output(this.loc("command-canceled", new Object[0]));
                }
                catch (SQLException sqle) {
                    this.handleException(sqle);
                }
            }
            catch (Throwable t) {
                this.handleException(t);
                callback.setToFailure();
            }
        }
        this.commands.closeall(null, new DispatchCallback());
        if (callback.isFailure()) {
            status = Status.OTHER;
        }
        return status;
    }

    public LineReader getConsoleReader(InputStream inputStream, History fileHistory) throws IOException {
        Terminal terminal;
        if (this.getLineReader() != null) {
            return this.getLineReader();
        }
        TerminalBuilder terminalBuilder = TerminalBuilder.builder().signalHandler((Terminal.SignalHandler)this.signalHandler);
        if (inputStream != null) {
            terminal = terminalBuilder.streams(inputStream, (OutputStream)System.out).build();
        } else {
            terminal = terminalBuilder.system(true).build();
            this.getOpts().set(BuiltInProperty.MAX_WIDTH, terminal.getWidth());
            this.getOpts().set(BuiltInProperty.MAX_HEIGHT, terminal.getHeight());
        }
        LineReaderBuilder lineReaderBuilder = LineReaderBuilder.builder().terminal(terminal).parser((Parser)new SqlLineParser(this)).variable("history-file", (Object)this.getOpts().getHistoryFile()).variable("line-offset", (Object)1).option(LineReader.Option.AUTO_LIST, false).option(LineReader.Option.AUTO_MENU, true).option(LineReader.Option.DISABLE_EVENT_EXPANSION, true);
        LineReader lineReader = inputStream == null ? lineReaderBuilder.appName("sqlline").completer((Completer)new SqlLineCompleter(this)).highlighter((Highlighter)new SqlLineHighlighter(this)).build() : lineReaderBuilder.build();
        this.addWidget(lineReader, this::nextColorSchemeWidget, "CHANGE_COLOR_SCHEME", KeyMap.alt((char)'h'));
        this.addWidget(lineReader, this::toggleLineNumbersWidget, "TOGGLE_LINE_NUMBERS", KeyMap.alt((String)KeyMap.ctrl((char)'n')));
        fileHistory.attach(lineReader);
        this.setLineReader(lineReader);
        return lineReader;
    }

    private void addWidget(LineReader lineReader, Widget widget, String name, CharSequence keySeq) {
        lineReader.getWidgets().put(name, widget);
        ((KeyMap)lineReader.getKeyMaps().get("emacs")).bind((Object)widget, keySeq);
        ((KeyMap)lineReader.getKeyMaps().get("viins")).bind((Object)widget, keySeq);
    }

    boolean nextColorSchemeWidget() {
        String current = this.getOpts().getColorScheme();
        Set<String> colorSchemes = this.application.getName2HighlightStyle().keySet();
        if ("default".equalsIgnoreCase(current)) {
            if (!colorSchemes.isEmpty()) {
                this.getOpts().setColorScheme(colorSchemes.iterator().next());
            } else {
                this.getOpts().setColorScheme("default");
            }
            return true;
        }
        Iterator<String> colorSchemeIterator = colorSchemes.iterator();
        while (colorSchemeIterator.hasNext()) {
            String nextColorScheme = colorSchemeIterator.next();
            if (!Objects.equals(nextColorScheme, current)) continue;
            if (colorSchemeIterator.hasNext()) {
                this.getOpts().setColorScheme(colorSchemeIterator.next());
            } else {
                this.getOpts().setColorScheme("default");
            }
            return true;
        }
        this.getOpts().setColorScheme("default");
        return true;
    }

    boolean toggleLineNumbersWidget() {
        this.getOpts().set(BuiltInProperty.SHOW_LINE_NUMBERS, !this.getOpts().getShowLineNumbers());
        this.getLineReader().callWidget("redisplay");
        return true;
    }

    void usage() {
        this.output(this.loc("cmd-usage", new Object[0]));
    }

    void dispatch(String line, DispatchCallback callback) {
        boolean echoToFile;
        if (line == null) {
            this.exit = true;
            return;
        }
        if (line.trim().length() == 0) {
            callback.setStatus(DispatchCallback.Status.SUCCESS);
            return;
        }
        if (this.isOneLineComment(line)) {
            callback.setStatus(DispatchCallback.Status.SUCCESS);
            return;
        }
        if (this.isHelpRequest(line = line.trim())) {
            line = "!help";
        }
        if (line.startsWith(COMMAND_PREFIX)) {
            CommandHandler matchingHandler;
            TreeMap<String, CommandHandler> cmdMap = new TreeMap<String, CommandHandler>();
            String commandLine = line.substring(1);
            for (CommandHandler commandHandler : this.getCommandHandlers()) {
                String match = commandHandler.matches(commandLine);
                if (match == null) continue;
                cmdMap.put(match, commandHandler);
            }
            switch (cmdMap.size()) {
                case 0: {
                    callback.setStatus(DispatchCallback.Status.FAILURE);
                    this.error(this.loc("unknown-command", commandLine));
                    return;
                }
                case 1: {
                    matchingHandler = (CommandHandler)cmdMap.values().iterator().next();
                    break;
                }
                default: {
                    matchingHandler = (CommandHandler)cmdMap.get(this.split(commandLine, 1)[0]);
                    if (matchingHandler != null) break;
                    callback.setStatus(DispatchCallback.Status.FAILURE);
                    this.error(this.loc("multiple-matches", cmdMap.keySet().toString()));
                    return;
                }
            }
            echoToFile = matchingHandler.echoToFile();
            callback.setStatus(DispatchCallback.Status.RUNNING);
            matchingHandler.execute(commandLine, callback);
        } else {
            echoToFile = true;
            callback.setStatus(DispatchCallback.Status.RUNNING);
            this.commands.sql(line, callback);
        }
        if (this.scriptOutputFile != null && echoToFile) {
            this.scriptOutputFile.addLine(line);
        }
    }

    boolean isHelpRequest(String line) {
        return line.equals("?") || line.equalsIgnoreCase("help");
    }

    boolean isOneLineComment(String line, boolean trim) {
        String[] inputLines;
        for (String inputLine : inputLines = line.split("\n")) {
            if (this.isComment(inputLine, trim)) continue;
            return false;
        }
        return true;
    }

    boolean isOneLineComment(String line) {
        return this.isOneLineComment(line, true);
    }

    private boolean isComment(String line, boolean trim) {
        String trimmedLine = trim ? line.trim() : line;
        for (String comment : this.getDialect().getSqlLineOneLineComments()) {
            if (!trimmedLine.startsWith(comment)) continue;
            return true;
        }
        return false;
    }

    public void output(String msg) {
        this.output(msg, true, this.getOutputStream());
    }

    public void info(String msg) {
        if (!this.getOpts().getSilent()) {
            this.output(msg, true, this.getErrorStream());
        }
    }

    public void info(AttributedString msg) {
        if (!this.getOpts().getSilent()) {
            this.output(msg, true, this.getErrorStream());
        }
    }

    public boolean error(String msg) {
        this.output(new AttributedString((CharSequence)msg, AttributedStyles.RED), true, this.errorStream);
        return false;
    }

    public boolean error(Throwable t) {
        this.handleException(t);
        return false;
    }

    public void debug(String msg) {
        if (this.getOpts().getVerbose()) {
            this.output(new AttributedString((CharSequence)msg, AttributedStyles.BLUE), true, this.errorStream);
        }
    }

    public void output(AttributedString msg) {
        this.output(msg, true);
    }

    public void output(AttributedString msg, boolean newline) {
        this.output(msg, newline, this.getOutputStream());
    }

    private void output(String msg, String ansiMsg, boolean newline, PrintStream out) {
        if (newline) {
            out.println(ansiMsg);
        } else {
            out.print(ansiMsg);
        }
        if (this.recordOutputFile == null) {
            return;
        }
        if (newline) {
            this.recordOutputFile.addLine(msg);
        }
    }

    public void output(String msg, boolean newline, PrintStream out) {
        this.output(msg, msg, newline, out);
    }

    public void output(AttributedString msg, boolean newline, PrintStream out) {
        if (this.getOpts().getColor()) {
            String ansiMsg = this.getTerminal() == null ? msg.toAnsi() : msg.toAnsi(this.getTerminal());
            this.output(msg.toString(), ansiMsg, newline, out);
        } else {
            this.output(msg.toString(), newline, out);
        }
    }

    void readonlyStatus(Connection c) throws SQLException {
        this.debug(this.loc("readonly-status", c.isReadOnly() + ""));
    }

    void autocommitStatus(Connection c) throws SQLException {
        this.debug(this.loc("autocommit-status", c.getAutoCommit() + ""));
    }

    boolean assertAutoCommit() {
        if (!this.assertConnection()) {
            return false;
        }
        try {
            if (this.getDatabaseConnection().connection.getAutoCommit()) {
                return this.error(this.loc("autocommit-needs-off", new Object[0]));
            }
        }
        catch (Exception e) {
            return this.error(e);
        }
        return true;
    }

    boolean assertConnection() {
        try {
            if (this.getDatabaseConnection() == null || this.getDatabaseConnection().connection == null) {
                return this.error(this.loc("no-current-connection", new Object[0]));
            }
            if (this.getDatabaseConnection().connection.isClosed()) {
                return this.error(this.loc("connection-is-closed", new Object[0]));
            }
        }
        catch (SQLException sqle) {
            return this.error(this.loc("no-current-connection", new Object[0]));
        }
        return true;
    }

    void showWarnings() {
        if (this.getDatabaseConnection().connection == null) {
            return;
        }
        if (!this.getOpts().getShowWarnings()) {
            return;
        }
        try {
            this.showWarnings(this.getDatabaseConnection().connection.getWarnings());
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    void showWarnings(SQLWarning warn) {
        SQLWarning next;
        if (warn == null) {
            return;
        }
        if (this.seenWarnings.get(warn) == null) {
            this.seenWarnings.put(warn, new Date());
            this.handleSQLException(warn);
        }
        if ((next = warn.getNextWarning()) != warn) {
            this.showWarnings(next);
        }
    }

    int getSize(ResultSet rs) {
        try {
            if (rs.getType() == 1003) {
                return -1;
            }
            rs.last();
            int total = rs.getRow();
            rs.beforeFirst();
            return total;
        }
        catch (AbstractMethodError | SQLException sqle) {
            return -1;
        }
    }

    ResultSet getColumns(String table) throws SQLException {
        if (!this.assertConnection()) {
            return null;
        }
        return this.getDatabaseConnection().meta.getColumns(this.getDatabaseConnection().meta.getConnection().getCatalog(), null, table, "%");
    }

    ResultSet getTables(String schemaTemplate) throws SQLException {
        if (!this.assertConnection()) {
            return null;
        }
        return this.getDatabaseConnection().meta.getTables(this.getDatabaseConnection().meta.getConnection().getCatalog(), schemaTemplate, "%", new String[]{"TABLE"});
    }

    String[] split(String line) {
        return this.split(line, 0);
    }

    String[] split(String line, int limit) {
        return this.split(line, " ", limit);
    }

    public String[][] splitCompound(String line, boolean keepSqlIdentifierQuotes) {
        int n;
        Dialect dialect = this.getDialect();
        int state = 0;
        int idStart = -1;
        char[] chars = line.toCharArray();
        for (n = chars.length; n > 0 && (Character.isWhitespace(chars[n - 1]) || chars[n - 1] == ';'); --n) {
        }
        ArrayList<String[]> words = new ArrayList<String[]>();
        ArrayList<String> current = new ArrayList<String>();
        int i = 0;
        block10: while (i < n) {
            char c = chars[i];
            switch (state) {
                case 0: 
                case 1: {
                    ++i;
                    if (Character.isWhitespace(c)) break;
                    if (c == '.') {
                        state = 1;
                        break;
                    }
                    if (c == dialect.getOpenQuote()) {
                        if (state == 0 && current.size() > 0) {
                            words.add(current.toArray(new String[current.size()]));
                            current.clear();
                        }
                        state = 2;
                        idStart = i;
                        break;
                    }
                    if (state == 0 && current.size() > 0) {
                        words.add(current.toArray(new String[current.size()]));
                        current.clear();
                    }
                    state = 3;
                    idStart = i - 1;
                    break;
                }
                case 2: {
                    ++i;
                    if (c != dialect.getCloseQuote()) continue block10;
                    if (i < n && chars[i] == dialect.getCloseQuote()) {
                        System.arraycopy(chars, i, chars, i - 1, n - i);
                        --n;
                        break;
                    }
                    state = 0;
                    String word = String.copyValueOf(chars, idStart, i - idStart - 1);
                    current.add(keepSqlIdentifierQuotes ? dialect.getOpenQuote() + word + dialect.getCloseQuote() : word);
                    break;
                }
                case 3: {
                    ++i;
                    if (!Character.isWhitespace(c) && c != '.') continue block10;
                    String word = String.copyValueOf(chars, idStart, i - idStart - 1);
                    if (word.equalsIgnoreCase("NULL")) {
                        word = null;
                    } else if (dialect.isUpper()) {
                        word = word.toUpperCase(Locale.ROOT);
                    } else if (dialect.isLower()) {
                        word = word.toLowerCase(Locale.ROOT);
                    }
                    current.add(word);
                    state = c == '.' ? 1 : 0;
                    break;
                }
                default: {
                    throw new AssertionError((Object)("unexpected state " + state));
                }
            }
        }
        switch (state) {
            case 0: 
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                String word = String.copyValueOf(chars, idStart, n - idStart);
                if (state == 3) {
                    if (word.equalsIgnoreCase("NULL")) {
                        word = null;
                    } else if (dialect.isUpper()) {
                        word = word.toUpperCase(Locale.ROOT);
                    } else if (dialect.isLower()) {
                        word = word.toLowerCase(Locale.ROOT);
                    }
                }
                current.add(word);
                break;
            }
            default: {
                throw new AssertionError((Object)("unexpected state " + state));
            }
        }
        if (current.size() > 0) {
            words.add(current.toArray(new String[0]));
        }
        return (String[][])words.toArray((T[])new String[0][]);
    }

    public String[][] splitCompound(String line) {
        return this.splitCompound(line, false);
    }

    Dialect getDialect() {
        DatabaseConnection databaseConnection = this.getDatabaseConnection();
        return databaseConnection == null || databaseConnection.getDialect() == null ? DialectImpl.getDefault() : databaseConnection.getDialect();
    }

    String dequote(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        if (str.length() == 1 && (str.charAt(0) == '\'' || str.charAt(0) == '\"') || (str.charAt(0) == '\"' || str.charAt(0) == '\'' || str.charAt(str.length() - 1) == '\"' || str.charAt(str.length() - 1) == '\'') && str.charAt(0) != str.charAt(str.length() - 1)) {
            throw new IllegalArgumentException("A quote should be closed for <" + str + ">");
        }
        char prevQuote = '\u0000';
        int index = 0;
        while (str.charAt(index) == str.charAt(str.length() - index - 1) && (str.charAt(index) == '\"' || str.charAt(index) == '\'')) {
            if (index == str.length() - index - 1) {
                if (prevQuote != str.charAt(index)) break;
                throw new IllegalArgumentException("A non-paired quote may not occur between the same quotes");
            }
            if (index == str.length() - index - 2) {
                ++index;
                break;
            }
            prevQuote = str.charAt(index);
            ++index;
        }
        return index == 0 ? str : str.substring(index, str.length() - index);
    }

    String[] split(String line, String delim) {
        return this.split(line, delim, 0);
    }

    public String[] split(String line, String delim, int limit) {
        if (delim.indexOf(39) != -1 || delim.indexOf(34) != -1) {
            throw new UnsupportedOperationException();
        }
        boolean inQuotes = false;
        int tokenStart = 0;
        int lastProcessedIndex = 0;
        ArrayList<String> tokens = new ArrayList<String>();
        for (int i = 0; i < line.length() && (limit <= 0 || tokens.size() != limit); ++i) {
            if (line.charAt(i) == '\'' || line.charAt(i) == '\"') {
                if (this.isCharEscaped(line, i)) continue;
                if (inQuotes) {
                    if (line.charAt(tokenStart) != line.charAt(i)) continue;
                    inQuotes = false;
                    tokens.add(line.substring(tokenStart, i + 1));
                    lastProcessedIndex = i;
                    continue;
                }
                tokenStart = i;
                inQuotes = true;
                continue;
            }
            if (line.regionMatches(i, delim, 0, delim.length())) {
                if (inQuotes) {
                    i += delim.length() - 1;
                    continue;
                }
                if (i <= 0 || line.regionMatches(i - delim.length(), delim, 0, delim.length()) || line.charAt(i - 1) == '\'' || line.charAt(i - 1) == '\"') continue;
                tokens.add(line.substring(tokenStart, i));
                lastProcessedIndex = i;
                i += delim.length() - 1;
                continue;
            }
            if (i <= 0 || !line.regionMatches(i - delim.length(), delim, 0, delim.length()) || inQuotes) continue;
            tokenStart = i;
        }
        if (lastProcessedIndex != line.length() - 1 && (limit == 0 || limit > tokens.size()) || lastProcessedIndex == 0 && line.length() == 1) {
            tokens.add(line.substring(tokenStart));
        }
        String[] ret = new String[tokens.size()];
        for (int i = 0; i < tokens.size(); ++i) {
            String token = (String)tokens.get(i);
            ret[i] = token != null && token.charAt(0) == '\"' ? this.unescape(this.dequote((String)tokens.get(i))) : this.dequote((String)tokens.get(i));
        }
        return ret;
    }

    String unescape(String input) {
        String escapingSymbols = "\\\"";
        StringBuilder builder = new StringBuilder();
        boolean escaping = true;
        for (int i = 0; i < input.length(); ++i) {
            if (escaping && input.charAt(i) == '\\' && i < input.length() - 1 && "\\\"".indexOf(input.charAt(i + 1)) != -1) {
                escaping = false;
                continue;
            }
            escaping = true;
            builder.append(input.charAt(i));
        }
        return builder.toString();
    }

    String escapeAndQuote(String input) {
        if (input == null || input.isEmpty()) {
            return "\"\"";
        }
        if (input.length() > 1 && input.charAt(0) == input.charAt(input.length() - 1) && (input.charAt(0) == '\"' || input.charAt(0) == '\'')) {
            return input;
        }
        String escapingSymbols = "\\\"";
        StringBuilder builder = new StringBuilder("\"");
        for (int i = 0; i < input.length(); ++i) {
            if ("\\\"".indexOf(input.charAt(i)) != -1) {
                builder.append("\\");
            }
            builder.append(input.charAt(i));
        }
        builder.append("\"");
        return builder.toString();
    }

    boolean isCharEscaped(String input, int charAt) {
        int current;
        if (charAt < 0 || charAt >= input.length()) {
            return false;
        }
        for (current = charAt; current > 0 && input.charAt(current - 1) == '\\'; --current) {
        }
        return (charAt - current) % 2 != 0;
    }

    static <K, V> Map<K, V> map(K key, V value, Object ... obs) {
        HashMap<Object, Object> m = new HashMap<Object, Object>();
        m.put(key, value);
        for (int i = 0; i < obs.length - 1; i += 2) {
            m.put(obs[i], obs[i + 1]);
        }
        return m;
    }

    static boolean getMoreResults(Statement stmnt) {
        try {
            return stmnt.getMoreResults();
        }
        catch (Throwable t) {
            return false;
        }
    }

    static String xmlEncode(String str, String charsCouldBeNotEncoded) {
        if (str == null) {
            return str;
        }
        StringBuilder sb = new StringBuilder();
        block7: for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '\"': {
                    if (charsCouldBeNotEncoded.indexOf(ch) == -1) {
                        sb.append("&quot;");
                        continue block7;
                    }
                    sb.append(ch);
                    continue block7;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '>': {
                    if (i > 1 && str.charAt(i - 1) == ']' && str.charAt(i - 2) == ']' || charsCouldBeNotEncoded.indexOf(ch) == -1) {
                        sb.append("&gt;");
                        continue block7;
                    }
                    sb.append(ch);
                    continue block7;
                }
                case '\'': {
                    if (charsCouldBeNotEncoded.indexOf(ch) == -1) {
                        sb.append("&apos;");
                        continue block7;
                    }
                    sb.append(ch);
                    continue block7;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    String[] split(String line, int assertLen, String usage) {
        String[] ret = this.split(line);
        if (ret.length != assertLen) {
            this.error(usage);
            return null;
        }
        return ret;
    }

    String wrap(String toWrap, int len, int start) {
        StringBuilder buff = new StringBuilder();
        StringBuilder line = new StringBuilder();
        char[] head = new char[start];
        Arrays.fill(head, ' ');
        StringTokenizer tok = new StringTokenizer(toWrap, " ");
        while (tok.hasMoreTokens()) {
            String next = tok.nextToken();
            int x = line.length();
            int index = next.indexOf(10);
            if (index >= 0) {
                line.setLength(x + index);
                buff.append((CharSequence)line).append(' ').append(next, 0, index).append(SEPARATOR).append(head);
                line.setLength(0);
                if (next.length() > index + 1) {
                    line.append(next.substring(index + 1));
                }
            } else {
                line.append(line.length() == 0 ? "" : " ").append(next);
            }
            if (line.length() <= len) continue;
            line.setLength(x);
            buff.append((CharSequence)line).append(SEPARATOR).append(head);
            line.setLength(0);
            line.append(next);
        }
        buff.append((CharSequence)line);
        return buff.toString();
    }

    static String rpad(String value, int padLen) {
        return String.format(Locale.ROOT, "%1$-" + padLen + "s", Objects.toString(value, ""));
    }

    static String center(String str, int len) {
        int i;
        int n = len - str.length();
        if (n <= 0) {
            return str;
        }
        StringBuilder buf = new StringBuilder();
        int left = n / 2;
        int right = n - left;
        for (i = 0; i < left; ++i) {
            buf.append(' ');
        }
        buf.append(str);
        for (i = 0; i < right; ++i) {
            buf.append(' ');
        }
        return buf.toString();
    }

    public void handleException(Throwable e) {
        while (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        if (e instanceof SQLException) {
            this.handleSQLException((SQLException)e);
        } else if (e instanceof WrappedSqlException) {
            this.handleSQLException((SQLException)e.getCause());
        } else if (!initComplete && !this.getOpts().getVerbose()) {
            if (e.getMessage() == null) {
                this.error(e.getClass().getName());
            } else {
                this.error(e.getMessage());
            }
        } else {
            e.printStackTrace(this.getErrorStream());
        }
    }

    void handleSQLException(SQLException e) {
        boolean showNested;
        boolean showWarnings = !initComplete || this.getOpts().getShowWarnings();
        boolean verbose = !initComplete || this.getOpts().getVerbose();
        boolean bl = showNested = !initComplete || this.getOpts().getShowNestedErrs();
        if (e instanceof SQLWarning && !showWarnings) {
            return;
        }
        String type = e instanceof SQLWarning ? this.loc("Warning", new Object[0]) : this.loc("Error", new Object[0]);
        this.error(this.loc(e instanceof SQLWarning ? "Warning" : "Error", e.getMessage() == null ? "" : e.getMessage().trim(), e.getSQLState() == null ? "" : e.getSQLState().trim(), e.getErrorCode()));
        if (verbose) {
            e.printStackTrace();
        }
        if (!showNested) {
            return;
        }
        for (SQLException nested = e.getNextException(); nested != null && nested != e; nested = nested.getNextException()) {
            this.handleSQLException(nested);
        }
    }

    String scanForDriver(String url) {
        try {
            Driver driver = this.findRegisteredDriver(url);
            if (driver != null) {
                return driver.getClass().getCanonicalName();
            }
            this.scanDrivers();
            driver = this.findRegisteredDriver(url);
            if (driver != null) {
                return driver.getClass().getCanonicalName();
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.debug(e.toString());
            return null;
        }
    }

    private Driver findRegisteredDriver(String url) {
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        while (drivers.hasMoreElements()) {
            Driver driver = drivers.nextElement();
            try {
                if (!driver.acceptsURL(url)) continue;
                return driver;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    Set<Driver> scanDrivers() {
        long start = System.currentTimeMillis();
        HashSet<Driver> scannedDrivers = new HashSet<Driver>();
        if (this.appConfig.allowedDrivers == null || !this.appConfig.allowedDrivers.isEmpty()) {
            HashSet<String> driverClasses = this.appConfig.allowedDrivers == null ? Collections.emptySet() : new HashSet<String>(this.appConfig.allowedDrivers);
            for (Driver driver : ServiceLoader.load(Driver.class)) {
                if (!driverClasses.isEmpty() && !driverClasses.contains(driver.getClass().getCanonicalName())) continue;
                scannedDrivers.add(driver);
            }
        }
        long end = System.currentTimeMillis();
        this.info("scan complete in " + (end - start) + "ms");
        return scannedDrivers;
    }

    int print(ResultSet rs, DispatchCallback callback) throws SQLException {
        String format = this.getOpts().getOutputFormat();
        OutputFormat f = this.getOutputFormats().get(format);
        if ("csv".equals(format)) {
            SeparatedValuesOutputFormat csvOutput = (SeparatedValuesOutputFormat)f;
            if (csvOutput.separator == null && this.getOpts().getCsvDelimiter() != null || csvOutput.separator != null && !csvOutput.separator.equals(this.getOpts().getCsvDelimiter()) || csvOutput.quoteCharacter != this.getOpts().getCsvQuoteCharacter()) {
                f = new SeparatedValuesOutputFormat(this, this.getOpts().getCsvDelimiter(), this.getOpts().getCsvQuoteCharacter());
                HashMap<String, OutputFormat> updFormats = new HashMap<String, OutputFormat>(this.getOutputFormats());
                updFormats.put("csv", f);
                this.updateOutputFormats(updFormats);
            }
        }
        Rows rows = this.getOpts().getIncremental() ? new IncrementalRows(this, rs, callback) : new BufferedRows(this, rs);
        return f.print(rows);
    }

    Statement createStatement() throws SQLException {
        int rowLimit;
        Statement stmnt = this.getDatabaseConnection().connection.createStatement();
        int timeout = this.getOpts().getTimeout();
        if (timeout > -1) {
            stmnt.setQueryTimeout(timeout);
        }
        if ((rowLimit = this.getOpts().getRowLimit()) != 0) {
            stmnt.setMaxRows(rowLimit);
        }
        return stmnt;
    }

    void runBatch(List<String> statements) {
        try (Statement stmnt = this.createStatement();){
            for (String statement : statements) {
                stmnt.addBatch(statement);
            }
            int[] counts = stmnt.executeBatch();
            if (counts == null) {
                counts = new int[]{};
            }
            this.output(new AttributedStringBuilder().append((CharSequence)SqlLine.rpad("COUNT", 8), AttributedStyle.BOLD).append((CharSequence)"STATEMENT", AttributedStyle.BOLD).toAttributedString());
            for (int i = 0; i < counts.length; ++i) {
                this.output(new AttributedStringBuilder().append((CharSequence)SqlLine.rpad(counts[i] + "", 8)).append((CharSequence)statements.get(i)).toAttributedString());
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    int runCommands(DispatchCallback callback, String ... cmds) {
        return this.runCommands(Arrays.asList(cmds), callback);
    }

    public int runCommands(List<String> cmds, DispatchCallback callback) {
        int successCount = 0;
        try {
            int index = 1;
            int size = cmds.size();
            for (String cmd : cmds) {
                this.info(new AttributedStringBuilder().append((CharSequence)SqlLine.rpad(index++ + "/" + size, 13)).append((CharSequence)cmd).toAttributedString());
                this.dispatch(cmd, callback);
                boolean success = callback.isSuccess();
                if (!success && !this.getOpts().getForce()) {
                    this.error(this.loc("abort-on-error", cmd));
                    return successCount;
                }
                successCount += success ? 1 : 0;
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return successCount;
    }

    void setCompletions() {
        if (this.getDatabaseConnection() != null) {
            this.getDatabaseConnection().setCompletions(this.getOpts().getFastConnect());
        }
    }

    void outputProperty(String key, String value) {
        this.output(new AttributedStringBuilder().append((CharSequence)SqlLine.rpad(key, 20), AttributedStyles.GREEN).append((CharSequence)value).toAttributedString());
    }

    public SqlLineOpts getOpts() {
        return this.appConfig.opts;
    }

    public void setOpts(SqlLineOpts opts) {
        this.appConfig = this.appConfig.withOpts(opts);
    }

    DatabaseConnections getDatabaseConnections() {
        return this.connections;
    }

    public boolean isExit() {
        return this.exit;
    }

    public void setExit(boolean exit) {
        this.exit = exit;
    }

    Set<Driver> getDrivers() {
        return this.drivers;
    }

    void setDrivers(Set<Driver> drivers) {
        this.drivers = drivers;
    }

    public static String getSeparator() {
        return SEPARATOR;
    }

    Commands getCommands() {
        return this.commands;
    }

    OutputFile getScriptOutputFile() {
        return this.scriptOutputFile;
    }

    void setScriptOutputFile(OutputFile script) {
        this.scriptOutputFile = script;
    }

    OutputFile getRecordOutputFile() {
        return this.recordOutputFile;
    }

    void setRecordOutputFile(OutputFile record) {
        this.recordOutputFile = record;
    }

    public void setOutputStream(PrintStream outputStream) {
        try {
            this.outputStream = new PrintStream((OutputStream)outputStream, true, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            this.handleException(e);
        }
    }

    PrintStream getOutputStream() {
        return this.outputStream;
    }

    public void setErrorStream(PrintStream errorStream) {
        try {
            this.errorStream = new PrintStream((OutputStream)errorStream, true, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            this.handleException(e);
        }
    }

    PrintStream getErrorStream() {
        return this.errorStream;
    }

    LineReader getLineReader() {
        return this.lineReader;
    }

    Terminal getTerminal() {
        return this.lineReader == null ? null : this.lineReader.getTerminal();
    }

    void setLineReader(LineReader reader) {
        this.lineReader = reader;
    }

    List<String> getBatch() {
        return this.batch;
    }

    void setBatch(List<String> batch) {
        this.batch = batch;
    }

    public Reflector getReflector() {
        return this.reflector;
    }

    public Completer getCommandCompleter() {
        return this.sqlLineCommandCompleter;
    }

    void setAppConfig(Application application) {
        this.setDrivers(null);
        this.application = application;
        this.appConfig = new Config(application);
    }

    public HighlightStyle getHighlightStyle() {
        return this.appConfig.name2highlightStyle.get(this.getOpts().getColorScheme());
    }

    public Collection<CommandHandler> getCommandHandlers() {
        return this.appConfig.commandHandlers;
    }

    public void updateCommandHandlers(Collection<CommandHandler> commandHandlers) {
        this.appConfig = this.appConfig.withCommandHandlers(commandHandlers);
    }

    public Map<String, OutputFormat> getOutputFormats() {
        return this.appConfig.formats;
    }

    public void updateOutputFormats(Map<String, OutputFormat> formats) {
        this.appConfig = this.appConfig.withFormats(formats);
    }

    public PromptHandler getPromptHandler() {
        return this.appConfig.promptHandler;
    }

    public void updatePromptHandler(PromptHandler promptHandler) {
        this.appConfig = this.appConfig.withPromptHandler(promptHandler);
    }

    public ConnectionMetadata getConnectionMetadata() {
        return this.connectionMetadata;
    }

    <R> R withPrompting(Supplier<R> action) {
        if (this.prompting) {
            throw new IllegalArgumentException();
        }
        this.prompting = true;
        try {
            R r = action.get();
            return r;
        }
        finally {
            this.prompting = false;
        }
    }

    boolean isPrompting() {
        return this.prompting;
    }

    static {
        String testClass = "org.jline.reader.LineReader";
        try {
            Class.forName(testClass);
        }
        catch (Throwable t) {
            String message = SqlLine.locStatic(RESOURCE_BUNDLE, System.err, "jline-missing", testClass);
            throw new ExceptionInInitializerError(message);
        }
    }

    public static enum Status {
        OK,
        ARGS,
        OTHER;

    }

    private class Config {
        final Collection<String> allowedDrivers;
        final SqlLineOpts opts;
        final Collection<CommandHandler> commandHandlers;
        final Map<String, OutputFormat> formats;
        final Map<String, HighlightStyle> name2highlightStyle;
        final PromptHandler promptHandler;

        Config(Application application) {
            this(application.allowedDrivers(), application.getOpts(sqlLine), application.getCommandHandlers(sqlLine), application.getOutputFormats(sqlLine), application.getName2HighlightStyle(), application.getPromptHandler(sqlLine));
        }

        Config(Collection<String> knownDrivers, SqlLineOpts opts, Collection<CommandHandler> commandHandlers, Map<String, OutputFormat> formats, Map<String, HighlightStyle> name2HighlightStyle, PromptHandler promptHandler) {
            this.allowedDrivers = knownDrivers == null ? null : Collections.unmodifiableSet(new HashSet<String>(knownDrivers));
            this.opts = opts;
            this.commandHandlers = Collections.unmodifiableList(new ArrayList<CommandHandler>(commandHandlers));
            this.formats = Collections.unmodifiableMap(formats);
            this.name2highlightStyle = name2HighlightStyle;
            this.promptHandler = promptHandler;
        }

        Config withCommandHandlers(Collection<CommandHandler> commandHandlers) {
            return new Config(this.allowedDrivers, this.opts, commandHandlers, this.formats, this.name2highlightStyle, this.promptHandler);
        }

        Config withFormats(Map<String, OutputFormat> formats) {
            return new Config(this.allowedDrivers, this.opts, this.commandHandlers, formats, this.name2highlightStyle, this.promptHandler);
        }

        Config withOpts(SqlLineOpts opts) {
            return new Config(this.allowedDrivers, opts, this.commandHandlers, this.formats, this.name2highlightStyle, this.promptHandler);
        }

        Config withPromptHandler(PromptHandler promptHandler) {
            return new Config(this.allowedDrivers, this.opts, this.commandHandlers, this.formats, this.name2highlightStyle, promptHandler);
        }
    }
}

