/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.tracing.opencensus;

import io.opencensus.trace.Status;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite.IgniteException;
import org.apache.ignite.spi.tracing.SpanStatus;

public class StatusMatchTable {
    private static final Map<SpanStatus, Status> table = new ConcurrentHashMap<SpanStatus, Status>();

    private StatusMatchTable() {
    }

    public static Status match(SpanStatus spanStatus) {
        Status res = table.get(spanStatus);
        if (res == null) {
            throw new IgniteException("Unknown span status (no matching with OpenCensus): " + spanStatus);
        }
        return res;
    }

    static {
        table.put(SpanStatus.OK, Status.OK);
        table.put(SpanStatus.CANCELLED, Status.CANCELLED);
        table.put(SpanStatus.ABORTED, Status.ABORTED);
    }
}

